/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.base;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.app.AlertDialog;
import com.xdja.im.base.di.component.DaggerUserComponent;
import com.xdja.im.base.di.component.RepositoryComponent;
import com.xdja.im.base.di.component.UserComponent;
import com.xdja.im.base.frame.BaseView;
import com.xdja.im.base.frame.Presenter;
import com.xdja.im.base.frame.presenter.BaseActivityPresenter;
import com.xdja.im.common.utils.CommonTool;
import com.xdja.im.uikit.ImUiKit;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.utils.log.LogUtil;

public abstract class ImBaseActivity<P extends Presenter, V extends BaseView>
extends BaseActivityPresenter<P, V> {
    protected UserComponent mComponent;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        this.setTheme(R.style.im_uikit_ImAppTheme);
        super.onCreate(savedInstanceState);
    }

    @Override
    protected void onBindView(@Nullable Bundle savedInstanceState) {
        super.onBindView(savedInstanceState);
        RepositoryComponent repositoryComponent = ImUiKit.getInstance().getComponent();
        if (repositoryComponent != null) {
            this.mComponent = DaggerUserComponent.builder().repositoryComponent(repositoryComponent).build();
        }
        if (this.mComponent == null) {
            LogUtil.e("Fatal :User component is null .");
            this.finish();
        }
    }

    public void startActivity(Intent intent) {
        super.startActivity(intent);
    }

    protected void showMissingPermissionDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setTitle((CharSequence)"\u63d0\u793a");
        builder.setMessage((CharSequence)"\u5f53\u524d\u5e94\u7528\u7f3a\u5c11\u5fc5\u8981\u6743\u9650\u3002\u8bf7\u70b9\u51fb\"\u8bbe\u7f6e\"-\"\u6743\u9650\"-\u6253\u5f00\u6240\u9700\u6743\u9650\u3002");
        builder.setNegativeButton((CharSequence)"\u53d6\u6d88", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                ImBaseActivity.this.finish();
            }
        });
        builder.setPositiveButton((CharSequence)"\u8bbe\u7f6e", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                ImBaseActivity.this.startAppSettings();
            }
        });
        builder.setCancelable(false);
        builder.show();
    }

    private void startAppSettings() {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        intent.setData(Uri.parse((String)("package:" + this.getPackageName())));
        this.startActivity(intent);
    }

    protected Context getContext() {
        return this;
    }

    protected void onDestroy() {
        super.onDestroy();
    }

    protected void showToast(String content) {
        CommonTool.showToast(content);
    }

    protected void showToast(int resId) {
        CommonTool.showToast(resId);
    }
}

