/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.base;

import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.IdRes;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v7.app.AlertDialog;
import com.xdja.im.base.di.component.DaggerUserComponent;
import com.xdja.im.base.di.component.RepositoryComponent;
import com.xdja.im.base.di.component.UserComponent;
import com.xdja.im.base.frame.Presenter;
import com.xdja.im.base.frame.presenter.BaseFragmentPresenter;
import com.xdja.im.base.frame.view.FragmentBaseView;
import com.xdja.im.common.utils.CommonTool;
import com.xdja.im.uikit.ImUiKit;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.utils.log.LogUtil;

public abstract class ImBaseFragment<P extends Presenter, V extends FragmentBaseView>
extends BaseFragmentPresenter<P, V> {
    protected UserComponent mComponent;

    @Override
    protected void onBindView(Bundle savedInstanceState) {
        super.onBindView(savedInstanceState);
        RepositoryComponent repositoryComponent = ImUiKit.getInstance().getComponent();
        if (repositoryComponent != null) {
            this.mComponent = DaggerUserComponent.builder().repositoryComponent(repositoryComponent).build();
        }
        if (this.mComponent == null) {
            LogUtil.e("Fatal :User component is null .");
            this.getActivity().finish();
        }
    }

    public void onDestroyView() {
        super.onDestroyView();
    }

    public void switchFragment(ImBaseFragment fragment, boolean addToBackStack) {
        this.switchFragment(fragment, 0x1020002, addToBackStack);
    }

    protected void switchFragment(ImBaseFragment fragment, @IdRes int contentRes, boolean addToBackStack) {
        FragmentManager fg = this.getFragmentManager();
        FragmentTransaction ft = fg.beginTransaction();
        if (addToBackStack) {
            ft.setCustomAnimations(R.anim.im_uikit_open_enter, R.anim.im_uikit_open_exit, R.anim.im_uikit_close_enter, R.anim.im_uikit_close_exit);
        }
        ft.replace(contentRes, (Fragment)fragment, fragment.getName());
        if (addToBackStack) {
            ft.addToBackStack(fragment.getName());
        }
        ft.commit();
    }

    protected void showMissingPermissionDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder(this.getContext());
        builder.setTitle((CharSequence)"\u63d0\u793a");
        builder.setMessage((CharSequence)"\u5f53\u524d\u5e94\u7528\u7f3a\u5c11\u5fc5\u8981\u6743\u9650\u3002\u8bf7\u70b9\u51fb\"\u8bbe\u7f6e\"-\"\u6743\u9650\"-\u6253\u5f00\u6240\u9700\u6743\u9650\u3002");
        builder.setNegativeButton((CharSequence)"\u53d6\u6d88", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                ImBaseFragment.this.getActivity().finish();
            }
        });
        builder.setPositiveButton((CharSequence)"\u8bbe\u7f6e", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                ImBaseFragment.this.startAppSettings();
            }
        });
        builder.setCancelable(false);
        builder.show();
    }

    private void startAppSettings() {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        intent.setData(Uri.parse((String)("package:" + this.getPackageName())));
        this.startActivity(intent);
    }

    protected void finish() {
        this.getActivity().finish();
    }

    protected void showToast(String content) {
        CommonTool.showToast(content);
    }

    protected void showToast(int resId) {
        CommonTool.showToast(resId);
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getPackageName() {
        return this.getContext().getPackageName();
    }
}

