/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.ui.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.widget.ListAdapter;
import com.squareup.otto.Subscribe;
import com.xdja.im.base.eventbus.BusProvider;
import com.xdja.im.common.utils.FileSizeUtils;
import com.xdja.im.common.utils.PermissionUtils;
import com.xdja.im.core.model.event.IMContactEvent;
import com.xdja.im.core.model.event.IMProxyFileEvent;
import com.xdja.im.core.model.event.IMProxyMessageEvent;
import com.xdja.im.core.model.event.IMProxySessionEvent;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.TalkSessionBean;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.core.model.message.file.NormalFileInfo;
import com.xdja.im.core.model.message.file.VoiceFileInfo;
import com.xdja.im.core.model.param.SessionParam;
import com.xdja.im.core.repository.interf.ProxyRepository;
import com.xdja.im.core.repository.interf.datasource.DiskDataStore;
import com.xdja.im.lib.action.bean.OptionBean;
import com.xdja.im.lib.action.uitls.OptionParser;
import com.xdja.im.lib.album.ImagePickerManager;
import com.xdja.im.lib.album.bean.ImageThumbBean;
import com.xdja.im.lib.audio.player.AudioListener;
import com.xdja.im.lib.audio.player.AudioListenerManager;
import com.xdja.im.lib.camera.CameraManager;
import com.xdja.im.lib.camera.bean.PhotoThumbBean;
import com.xdja.im.lib.file.FileExplorerManager;
import com.xdja.im.lib.file.bean.FileItem;
import com.xdja.im.lib.video.VideoRecorderManager;
import com.xdja.im.lib.video.bean.VideoItem;
import com.xdja.im.uikit.IntentParam;
import com.xdja.im.uikit.base.ImBaseActivity;
import com.xdja.im.uikit.notification.NotificationUtil;
import com.xdja.im.uikit.ui.adapter.ChatListAdapter;
import com.xdja.im.uikit.ui.presenter.ChatListPresenter;
import com.xdja.im.uikit.ui.view.ViewChatList;
import com.xdja.im.uikit.ui.view.vu.ChatListVu;
import com.xdja.im.uikit.utils.DataConvertUtils;
import com.xdja.im.uikit.utils.ImageCache;
import com.xdja.im.uikit.utils.audio.AudioPlayerManagerProxy;
import com.xdja.im.uikit.utils.file.TranslateInfoUtil;
import com.xdja.im.uikit.utils.log.LogUtil;
import dagger.Lazy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import rx.Observable;
import rx.Subscriber;
import rx.android.schedulers.AndroidSchedulers;
import rx.functions.Func1;
import rx.schedulers.Schedulers;

public class ChatListActivity
extends ImBaseActivity<ChatListPresenter, ChatListVu>
implements ChatListPresenter,
AudioListener {
    private static final int PAGE_SIZE = 15;
    @Inject
    Lazy<ProxyRepository> proxyRepository;
    @Inject
    Lazy<DiskDataStore> diskDataStore;
    private String mTalkId;
    private int mTalkType;
    private boolean isLimit = false;
    private boolean isHasDraft;
    private List<TalkMessageBean> mMessageList = new ArrayList<TalkMessageBean>();
    private ChatListAdapter mAdapter;

    @Override
    protected Class<? extends ChatListVu> getVuClass() {
        return ViewChatList.class;
    }

    @Override
    @NonNull
    protected ChatListPresenter getPresenter() {
        return this;
    }

    @Override
    public Activity getActivity() {
        return this;
    }

    @Override
    public String getTalkFlag() {
        return this.mTalkId + "_" + this.mTalkType;
    }

    @Override
    protected void onBindView(Bundle savedInstanceState) {
        super.onBindView(savedInstanceState);
        this.obtainTalker();
        if (this.mComponent == null || TextUtils.isEmpty((CharSequence)this.mTalkId)) {
            this.finish();
            return;
        }
        this.mComponent.inject(this);
        BusProvider.getInstance().register(this);
        NotificationUtil.getInstance().setCurTalkAccount(this.mTalkId);
        AudioListenerManager.getInstance().addListener(this);
        this.initView();
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        this.setIntent(intent);
        this.recreate();
    }

    protected void onStart() {
        super.onStart();
        this.requestPermissions();
    }

    private void obtainTalker() {
        Bundle arguments = this.getIntent().getExtras();
        if (arguments != null) {
            this.mTalkId = arguments.getString("talkerId");
            this.mTalkType = arguments.getInt("talkType", 1);
        }
    }

    private void initView() {
        this.loadMessageList(0L);
        this.clearUnReadMsgCount();
        this.getDraftContent();
        this.startLoadOptions();
        ((ChatListVu)this.getVu()).setToolBarVisibility(0);
        ((ChatListVu)this.getVu()).setToolBarAddVisibility(0);
    }

    private void requestPermissions() {
        if (!PermissionUtils.hasSelfPermissions((Context)this.getActivity(), "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE")) {
            PermissionUtils.requestPermissions(this.getActivity(), new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"}, 1);
        }
    }

    private ChatListAdapter buildAdapter() {
        if (this.mAdapter == null) {
            this.mAdapter = new ChatListAdapter(this, this.mMessageList, ((ChatListVu)this.getVu()).getListView(), (ProxyRepository)this.proxyRepository.get());
            ((ChatListVu)this.getVu()).getListView().setAdapter((ListAdapter)this.mAdapter);
        }
        return this.mAdapter;
    }

    private void loadMessageList(final long msgId) {
        LogUtil.d("Start load message msgId " + msgId);
        ((ProxyRepository)this.proxyRepository.get()).getMessageList(this.mTalkId, this.mTalkType, msgId, 15, new Subscriber<List<TalkMessageBean>>(){

            public void onCompleted() {
                if (((ChatListVu)ChatListActivity.this.getVu()).isRefreshing()) {
                    ((ChatListVu)ChatListActivity.this.getVu()).stopRefresh();
                }
            }

            public void onError(Throwable e) {
                LogUtil.e("load message error:" + e.getMessage());
                if (((ChatListVu)ChatListActivity.this.getVu()).isRefreshing()) {
                    ((ChatListVu)ChatListActivity.this.getVu()).stopRefresh();
                }
            }

            public void onNext(List<TalkMessageBean> talkMessageList) {
                LogUtil.d(talkMessageList.toString());
                if (talkMessageList == null) {
                    return;
                }
                if (msgId == 0L) {
                    ChatListActivity.this.mMessageList.clear();
                }
                ChatListActivity.this.mMessageList.addAll(0, talkMessageList);
                ChatListActivity.this.buildAdapter().notifyDataSetChanged();
                LogUtil.d("Load message is refreshing " + ((ChatListVu)ChatListActivity.this.getVu()).isRefreshing());
                if (((ChatListVu)ChatListActivity.this.getVu()).isRefreshing()) {
                    if (talkMessageList.size() > 0) {
                        ((ChatListVu)ChatListActivity.this.getVu()).setListSelection(talkMessageList.size() - 1);
                    }
                } else {
                    ((ChatListVu)ChatListActivity.this.getVu()).setListSelection(ChatListActivity.this.mMessageList.size() - 1);
                    ((ChatListVu)ChatListActivity.this.getVu()).restoreActionState();
                }
            }
        });
    }

    private void startLoadOptions() {
        Observable.just((Object)"").subscribeOn(Schedulers.newThread()).flatMap((Func1)new Func1<String, Observable<OptionBean>>(){

            public Observable<OptionBean> call(String s) {
                try {
                    List<OptionBean> options = OptionParser.getOptions((Context)ChatListActivity.this.getActivity());
                    return Observable.from(options);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return Observable.error((Throwable)e);
                }
            }
        }).filter((Func1)new Func1<OptionBean, Boolean>(){

            public Boolean call(OptionBean optionBean) {
                if (ChatListActivity.this.mTalkType == 2) {
                    return optionBean.getType() != 1;
                }
                if (ChatListActivity.this.mTalkType == 1) {
                    return optionBean.getType() != 2;
                }
                return true;
            }
        }).toList().observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<List<OptionBean>>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                LogUtil.e("ERROR: Load options data error." + e.getMessage());
            }

            public void onNext(List<OptionBean> optionBeen) {
                LogUtil.d("ChatOptions:" + optionBeen.toString());
                ((ChatListVu)ChatListActivity.this.getVu()).setOptions(optionBeen);
            }
        });
    }

    @Override
    public void downRefreshList() {
        long msgId = 0L;
        if (!this.mMessageList.isEmpty()) {
            msgId = this.mMessageList.get(0).getId();
        }
        LogUtil.d("do refresh, msgId :" + msgId);
        this.loadMessageList(msgId);
    }

    private void notifyUpdateLastSession() {
        String draftContent = ((ChatListVu)this.getVu()).getInputContent();
        if (draftContent != null && !TextUtils.isEmpty((CharSequence)draftContent.trim())) {
            this.updateDraftContent(draftContent);
        } else {
            if (!this.mMessageList.isEmpty()) {
                TalkSessionBean updateSessionBean = new TalkSessionBean();
                TalkMessageBean lastMessageBean = this.mMessageList.get(this.mMessageList.size() - 1);
                updateSessionBean.setContent(lastMessageBean.getContent());
                updateSessionBean.setLastTime(lastMessageBean.getShowTime());
                updateSessionBean.setLastMsg(lastMessageBean);
                this.sendNotifyUpdateEvent(updateSessionBean);
            } else {
                TalkSessionBean updateSessionBean = new TalkSessionBean();
                updateSessionBean.setContent("");
                updateSessionBean.setLastTime(0L);
                this.sendNotifyUpdateEvent(updateSessionBean);
            }
            if (this.isHasDraft) {
                this.updateDraftContent(draftContent);
            }
        }
    }

    private void sendNotifyUpdateEvent(TalkSessionBean bean) {
        bean.setTalkFlag(this.getTalkFlag());
        IMProxySessionEvent.RefreshSessionEvent event = new IMProxySessionEvent.RefreshSessionEvent();
        event.setSessionBean(bean);
        event.setUpdateData(true);
        BusProvider.getInstance().post(event);
    }

    private void getDraftContent() {
        ((DiskDataStore)this.diskDataStore.get()).getDraftContent(this.getTalkFlag(), new Subscriber<String>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                LogUtil.e("ERROR: Get draft content failed.");
            }

            public void onNext(String s) {
                if (!TextUtils.isEmpty((CharSequence)s)) {
                    ChatListActivity.this.isHasDraft = true;
                    ((ChatListVu)ChatListActivity.this.getVu()).setInputContent(s);
                }
            }
        });
    }

    private void updateDraftContent(final String draftContent) {
        ((ProxyRepository)this.proxyRepository.get()).getProxyConfig("diff").subscribe((Subscriber)new Subscriber<String>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                LogUtil.e("ERROR: Sync time difference failed." + e.getMessage());
                long draftTime = System.currentTimeMillis();
                if (draftContent != null && !TextUtils.isEmpty((CharSequence)draftContent.trim())) {
                    ChatListActivity.this.saveDraft(draftContent, draftTime);
                } else {
                    ChatListActivity.this.clearDraft(draftTime);
                }
            }

            public void onNext(String s) {
                long draftTime = 0L;
                if (!TextUtils.isEmpty((CharSequence)s)) {
                    try {
                        draftTime = (SystemClock.elapsedRealtimeNanos() + Long.parseLong(s)) / 1000000L;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                draftTime = draftTime > 0L ? draftTime : System.currentTimeMillis();
                LogUtil.d("Draft: content:" + draftContent + ", time:" + draftTime);
                if (draftContent != null && !TextUtils.isEmpty((CharSequence)draftContent.trim())) {
                    ChatListActivity.this.saveDraft(draftContent, draftTime);
                } else {
                    ChatListActivity.this.clearDraft(draftTime);
                }
            }
        });
    }

    private void saveDraft(String draftContent, long draftTime) {
        ((DiskDataStore)this.diskDataStore.get()).saveDraftContent(this.getTalkFlag(), draftContent, draftTime, new Subscriber<Boolean>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                LogUtil.e("ERROR: save draft failed.");
            }

            public void onNext(Boolean aBoolean) {
                LogUtil.d("Save draft successfully.");
            }
        });
        TalkSessionBean updateSessionBean = new TalkSessionBean();
        SessionParam param = new SessionParam();
        param.setDraftContent(draftContent);
        param.setDraftTime(draftTime);
        updateSessionBean.setParam(param);
        this.sendNotifyUpdateEvent(updateSessionBean);
    }

    private void clearDraft(final long draftTime) {
        ((DiskDataStore)this.diskDataStore.get()).clearDraftContent(this.getTalkFlag(), draftTime, new Subscriber<Boolean>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                LogUtil.e("ERROR: Clear draft failed. " + e.getMessage());
                TalkSessionBean updateSessionBean = new TalkSessionBean();
                SessionParam param = new SessionParam();
                param.setDraftContent("");
                param.setDraftTime(draftTime);
                updateSessionBean.setParam(param);
                ChatListActivity.this.sendNotifyUpdateEvent(updateSessionBean);
            }

            public void onNext(Boolean aBoolean) {
                LogUtil.d("Clear draft successfully.");
                TalkSessionBean updateSessionBean = new TalkSessionBean();
                if (!ChatListActivity.this.mMessageList.isEmpty()) {
                    TalkMessageBean lastMessageBean = (TalkMessageBean)ChatListActivity.this.mMessageList.get(ChatListActivity.this.mMessageList.size() - 1);
                    updateSessionBean.setContent(lastMessageBean.getContent());
                    updateSessionBean.setLastTime(lastMessageBean.getShowTime());
                } else {
                    SessionParam param = new SessionParam();
                    param.setDraftContent("");
                    param.setDraftTime(draftTime);
                    updateSessionBean.setParam(param);
                }
                ChatListActivity.this.sendNotifyUpdateEvent(updateSessionBean);
            }
        });
    }

    private void clearUnReadMsgCount() {
        NotificationUtil.getInstance().clearPNNotification();
        ((ProxyRepository)this.proxyRepository.get()).clearUnReadMsgCount(this.getTalkFlag(), new Subscriber<Integer>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                LogUtil.d("Error:clear unRead msg flag failed.");
            }

            public void onNext(Integer integer) {
                LogUtil.d("clear unRead msg flag successfully.");
            }
        });
    }

    @Override
    public int getMessageSize() {
        return this.mMessageList.size();
    }

    @Override
    public boolean sendTextMessage(String message) {
        LogUtil.d("send text message:" + message);
        ((ProxyRepository)this.proxyRepository.get()).sendTextMessage(message, this.mTalkId, this.isLimit, this.mTalkType == 2, new Subscriber<TalkMessageBean>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                LogUtil.e("send text error, ERROR:" + e.getMessage());
            }

            public void onNext(TalkMessageBean talkMessageBean) {
                int index = ChatListActivity.this.mMessageList.indexOf(talkMessageBean);
                if (index >= 0) {
                    return;
                }
                ChatListActivity.this.mMessageList.add(talkMessageBean);
                ChatListActivity.this.mAdapter.notifyDataSetChanged();
                ((ChatListVu)ChatListActivity.this.getVu()).setListSelection(ChatListActivity.this.mMessageList.size() - 1);
            }
        });
        return true;
    }

    @Override
    public void sendFileMessage(List<FileInfo> fileList) {
        LogUtil.d("send file message:" + fileList.toString());
        ((ProxyRepository)this.proxyRepository.get()).sendFileMessage(this.mTalkId, this.isLimit, this.mTalkType == 2, fileList, new Subscriber<TalkMessageBean>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                LogUtil.e("send file ERROR:" + e.getMessage());
            }

            public void onNext(TalkMessageBean bean) {
                int index = ChatListActivity.this.mMessageList.indexOf(bean);
                if (index >= 0) {
                    return;
                }
                ChatListActivity.this.mMessageList.add(bean);
                ChatListActivity.this.mAdapter.notifyDataSetChanged();
                ((ChatListVu)ChatListActivity.this.getVu()).setListSelection(ChatListActivity.this.mMessageList.size() - 1);
            }
        });
    }

    @Override
    public void sendVoiceMessage(String path, int seconds) {
        VoiceFileInfo voiceFileInfo = new VoiceFileInfo();
        voiceFileInfo.setAmountOfTime(seconds);
        voiceFileInfo.setFilePath(path);
        voiceFileInfo.setFileName(path.substring(path.lastIndexOf("/") + 1, path.length()));
        voiceFileInfo.setFileSize(FileSizeUtils.getFileSize(path));
        voiceFileInfo.setSuffix("amr");
        voiceFileInfo.setFileType(1);
        ArrayList<FileInfo> fileInfoList = new ArrayList<FileInfo>();
        fileInfoList.add(voiceFileInfo);
        this.sendFileMessage(fileInfoList);
    }

    private Intent buildIntent(OptionBean optionBean) {
        Intent intent = new Intent();
        if (!TextUtils.isEmpty((CharSequence)optionBean.getPkgName())) {
            intent.setClassName(optionBean.getPkgName(), optionBean.getClsName());
            intent.setFlags(0x10000000);
        } else {
            intent.setClassName(this.getPackageName(), optionBean.getClsName());
        }
        Map<String, String> params = optionBean.getParam();
        if (params != null && !params.isEmpty()) {
            for (Map.Entry<String, String> entity : params.entrySet()) {
                intent.putExtra(entity.getKey(), entity.getValue());
            }
        }
        intent.putExtra("talkerId", this.mTalkId);
        intent.putExtra("talkType", this.mTalkType);
        return intent;
    }

    @Override
    public void startToOptionView(int position, OptionBean optionBean) {
        LogUtil.d("startToOptionView:" + optionBean.toString());
        Intent intent = this.buildIntent(optionBean);
        try {
            if (optionBean.getRequestCode() > 0) {
                this.startActivityForResult(intent, optionBean.getRequestCode());
            } else {
                this.startActivity(intent);
            }
            ((ChatListVu)this.getVu()).restoreActionState();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void startToAlbum() {
        ((ChatListVu)this.getVu()).restoreActionState();
        ImagePickerManager.getInstance().openAlbum((Activity)this, 2);
    }

    @Override
    public void startToCamera() {
        ((ChatListVu)this.getVu()).restoreActionState();
        CameraManager.getInstance().startTakePhoto((Activity)this, 3);
    }

    @Override
    public void startToFileExplorer() {
        ((ChatListVu)this.getVu()).restoreActionState();
        FileExplorerManager.getInstance().openFileExplorer((Activity)this, 6);
    }

    @Override
    public void startToVideo() {
        ((ChatListVu)this.getVu()).restoreActionState();
        VideoRecorderManager.getInstance().startVideoRecorder((Activity)this, 5);
    }

    @Override
    public void startSetting() {
        ((ChatListVu)this.getVu()).restoreActionState();
        IntentParam.startSettingActivity((Context)this.getActivity(), this.mTalkId);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        LogUtil.d("onActivityResult requestCode:" + requestCode);
        if (data == null) {
            LogUtil.w("ERROR: on bad activity result, data is null.");
            return;
        }
        switch (resultCode) {
            case 1: {
                break;
            }
            case 2: {
                this.handleAlbumResult(data);
                break;
            }
            case 3: {
                this.handleCameraResult(data);
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this.handleVideoRecorderResult(data);
                break;
            }
            case 6: {
                this.handleFileResult(data);
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                this.handleFileLoadResult(data);
            }
        }
    }

    private void handleAlbumResult(Intent data) {
        ArrayList thumbBeen = data.getParcelableArrayListExtra("album_pic_select");
        if (thumbBeen == null || thumbBeen.isEmpty()) {
            LogUtil.e("ERROR: thumb list is null or empty.");
            return;
        }
        ArrayList<FileInfo> imageFileInfoList = new ArrayList<FileInfo>();
        for (ImageThumbBean bean : thumbBeen) {
            FileInfo fileInfo = DataConvertUtils.mapImageFileInfo(bean);
            if (fileInfo == null) continue;
            imageFileInfoList.add(fileInfo);
        }
        this.sendFileMessage(imageFileInfoList);
    }

    private void handleCameraResult(Intent data) {
        PhotoThumbBean thumbBean = (PhotoThumbBean)data.getParcelableExtra("album_photo");
        if (thumbBean == null) {
            LogUtil.e("ERROR: thumb list is null or empty.");
            return;
        }
        ArrayList<FileInfo> photoFileInfos = new ArrayList<FileInfo>();
        FileInfo photoFileInfo = DataConvertUtils.mapPhotoFileInfo(thumbBean);
        if (photoFileInfo != null) {
            photoFileInfos.add(photoFileInfo);
        }
        this.sendFileMessage(photoFileInfos);
    }

    private void handleVideoRecorderResult(Intent data) {
        VideoItem videoItem = (VideoItem)data.getParcelableExtra("im_uikit_video_recorder");
        if (videoItem == null) {
            LogUtil.e("ERROR: videoItem is null.");
            return;
        }
        FileInfo videoFileInfo = DataConvertUtils.mapVideoFileInfo(videoItem);
        ArrayList<FileInfo> videoFileInfoList = new ArrayList<FileInfo>();
        videoFileInfoList.add(videoFileInfo);
        this.sendFileMessage(videoFileInfoList);
    }

    private void handleFileResult(Intent data) {
        ArrayList fileItemList = data.getParcelableArrayListExtra("file_select");
        if (fileItemList == null || fileItemList.isEmpty()) {
            LogUtil.e("ERROR: file list is null or empty.");
            return;
        }
        ArrayList<FileInfo> fileInfoList = new ArrayList<FileInfo>();
        for (FileItem bean : fileItemList) {
            FileInfo fileInfo = DataConvertUtils.mapFileInfo(bean);
            if (fileInfo == null) continue;
            fileInfoList.add(fileInfo);
        }
        this.sendFileMessage(fileInfoList);
    }

    private void handleFileLoadResult(Intent data) {
        Bundle bundle = data.getExtras();
        if (bundle == null) {
            LogUtil.e("ERROR: hand file load result, bundle is null.");
            return;
        }
        long msgId = bundle.getLong("messageId", -1L);
        int state = bundle.getInt("fileState", 1);
        long translateSize = bundle.getLong("fileTranslateSize", 0L);
        int position = this.mathMessage(msgId);
        if (position < 0) {
            LogUtil.w("Result file downloadFile code, position:" + position);
            return;
        }
        TalkMessageBean bean = this.mMessageList.get(position);
        NormalFileInfo fileInfo = (NormalFileInfo)bean.getFileInfo();
        if (fileInfo != null) {
            fileInfo.setTranslateSize(translateSize);
            fileInfo.setFileState(state);
            this.mAdapter.updateItem(position, bean);
        }
    }

    private void updateFileTranslateSize() {
        for (TalkMessageBean bean : this.mMessageList) {
            FileInfo fileInfo = bean.getFileInfo();
            if (fileInfo == null || bean.getMessageType() != 4 && bean.getMessageType() != 2 || bean.getFileInfo() == null || bean.getFileInfo().getTranslateSize() == 0L || bean.getFileInfo().getTranslateSize() == bean.getFileInfo().getFileSize()) continue;
            TranslateInfoUtil.putInfo(bean.getId(), fileInfo.getTranslateSize());
        }
    }

    public void onPause() {
        super.onPause();
        AudioPlayerManagerProxy.stopPlay();
        this.clearUnReadMsgCount();
        this.notifyUpdateLastSession();
        this.updateFileTranslateSize();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        this.isHasDraft = false;
        AudioPlayerManagerProxy.stopPlay();
        AudioListenerManager.getInstance().clearAll();
        ImageCache.getInstance().clearAllCache();
        try {
            BusProvider.getInstance().unregister(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void changeMsgState(TalkMessageBean bean) {
        int position = this.mathMessage(bean.getId());
        if (position < 0) {
            LogUtil.e("ERROR: Change Msg State, position:" + position);
            return;
        }
        TalkMessageBean messageBean = this.mMessageList.get(position);
        if (messageBean != null) {
            messageBean.setMessageState(bean.getMessageState());
            messageBean.setFailCode(bean.getFailCode());
            messageBean.setContent(bean.getContent());
            this.mAdapter.updateItem(position, messageBean);
        }
    }

    private void addNewMessageToList(List<TalkMessageBean> talkMessageList) {
        int scrolledX = ((ChatListVu)this.getVu()).getListView().getScrollX();
        int scrolledY = ((ChatListVu)this.getVu()).getListView().getScrollY();
        this.mMessageList.addAll(talkMessageList);
        this.mAdapter.notifyDataSetChanged();
        int lastVisiblePosition = ((ChatListVu)this.getVu()).getListView().getLastVisiblePosition();
        if (this.mMessageList.size() > 15) {
            if (lastVisiblePosition <= this.mMessageList.size() - 1 && lastVisiblePosition > this.mMessageList.size() - 1 - 15) {
                ((ChatListVu)this.getVu()).setListSelection(this.mMessageList.size() - 1);
            } else {
                ((ChatListVu)this.getVu()).scrollTo(scrolledX, scrolledY);
            }
        } else {
            ((ChatListVu)this.getVu()).setListSelection(this.mMessageList.size() - 1);
        }
    }

    @Subscribe
    public void onReceiveNewMessage(IMProxyMessageEvent.ReceiveNewMessageEvent event) {
        LogUtil.d("EVENT: Receive a new message.");
        List<TalkMessageBean> talkMessageList = event.getTalkMessageList();
        if (talkMessageList == null || talkMessageList.isEmpty()) {
            LogUtil.w("receive new message event, but messageBean is null or empty.");
            return;
        }
        String from = event.getMsgAccount();
        if (TextUtils.isEmpty((CharSequence)from) || !TextUtils.equals((CharSequence)from, (CharSequence)this.mTalkId)) {
            LogUtil.w("receive new message event, but account is empty.");
            return;
        }
        this.addNewMessageToList(talkMessageList);
    }

    @Subscribe
    public void onDeleteMessage(IMProxyMessageEvent.DeleteMessageEvent event) {
        LogUtil.d("EVENT: Delete a new message.");
        TalkMessageBean talkMessageBean = event.getTalkMessageBean();
        FileInfo fileInfo = talkMessageBean.getFileInfo();
        if (fileInfo != null && fileInfo.getFileType() == 1) {
            AudioPlayerManagerProxy.stopPlay();
        }
        this.mMessageList.remove(talkMessageBean);
        this.mAdapter.notifyDataSetChanged();
    }

    @Subscribe
    public void onRefreshMessage(IMProxyMessageEvent.RefreshMessageEvent event) {
        LogUtil.d("EVENT: refresh single message.");
        TalkMessageBean bean = event.getTalkMessageBean();
        if (bean == null) {
            LogUtil.e("refresh single message, but messageBean is null.");
            return;
        }
        this.changeMsgState(bean);
    }

    @Subscribe
    public void onRefreshMessageList(IMProxyMessageEvent.RefreshMessageListEvent event) {
        LogUtil.d("EVENT: refresh message list.");
        if (event.isNeedClearInput()) {
            this.isHasDraft = false;
            ((ChatListVu)this.getVu()).setInputContent("");
        }
        this.loadMessageList(0L);
    }

    @Subscribe
    public void onRecallMessage(IMProxyMessageEvent.RecallMessageEvent event) {
        TalkMessageBean bean = event.getTalkMessageBean();
        if (bean == null) {
            LogUtil.e("refresh single message, but messageBean is null.");
            return;
        }
        int position = this.mathMessage(bean.getId());
        if (position < 0) {
            LogUtil.w("math message failed." + bean.getId());
            return;
        }
        this.mMessageList.set(position, bean);
        this.mAdapter.updateItem(position, bean);
    }

    @Subscribe
    public void onSendFileComplete(IMProxyFileEvent.SendFileFinishedEvent event) {
        LogUtil.d("EVENT: Send file complete.");
        int position = this.mathMessage(event.getAttachedMsgId());
        if (position < 0) {
            LogUtil.e("ERROR: Send file completed. position:" + position);
            return;
        }
        FileInfo fileInfo = this.mMessageList.get(position).getFileInfo();
        if (fileInfo == null) {
            LogUtil.e("ERROR: Send file completed, but fileInfo is null.");
            return;
        }
        fileInfo.setFileState(2);
        this.updateFileInfo(position, fileInfo);
        if (fileInfo.getFileType() == 1) {
            LogUtil.d("Voice send finished.");
            return;
        }
        TranslateInfoUtil.remove(fileInfo.getTalkMessageId());
    }

    @Subscribe
    public void onSendFilePause(IMProxyFileEvent.SendFilePausedEvent event) {
        LogUtil.d("EVENT: Send file pause.");
    }

    @Subscribe
    public void onSendFileProgressUpdate(IMProxyFileEvent.SendFileProgressUpdateEvent event) {
        LogUtil.d("EVENT: Send file progress update.");
        int position = this.mathMessage(event.getAttachedMsgId());
        if (position < 0) {
            LogUtil.w("Error: Send file progress update, position: " + position);
            return;
        }
        FileInfo fileInfo = this.mMessageList.get(position).getFileInfo();
        if (fileInfo == null) {
            LogUtil.e("ERROR: Send file progress update, but post fileInfo is null.");
            return;
        }
        if (fileInfo.getFileType() != 11) {
            LogUtil.d("No need update file progress.");
            return;
        }
        if (event.getFileInfo() != null) {
            fileInfo.setTranslateSize(event.getFileInfo().getTranslateSize());
        }
        fileInfo.setFileState(3);
        this.updateFileInfo(position, fileInfo);
    }

    @Subscribe
    public void onSendFileFailed(IMProxyFileEvent.SendFileFailedEvent event) {
        LogUtil.d("EVENT: Send file failed.");
        int position = this.mathMessage(event.getAttachedMsgId());
        if (position < 0) {
            LogUtil.e("ERROR: send file failed, position:" + position);
            return;
        }
        FileInfo fileInfo = this.mMessageList.get(position).getFileInfo();
        if (fileInfo == null) {
            LogUtil.e("ERROR: Send file failed , but fileInfo is null.");
            return;
        }
        fileInfo.setFileState(5);
        this.updateFileInfo(position, fileInfo);
    }

    @Subscribe
    public void onReceiveFileComplete(IMProxyFileEvent.ReceiveFileFinishedEvent event) {
        LogUtil.d("EVENT: Receive file complete.");
        int position = this.mathMessage(event.getAttachedMsgId());
        if (position < 0) {
            LogUtil.e("ERROR: Receive file completed, position:" + position);
            return;
        }
        FileInfo fileInfo = this.mMessageList.get(position).getFileInfo();
        if (fileInfo == null) {
            LogUtil.e("ERROR: Receive file completed, but fileInfo is null.");
            return;
        }
        fileInfo.setFileState(2);
        this.updateFileInfo(position, fileInfo);
        TranslateInfoUtil.remove(fileInfo.getTalkMessageId());
    }

    @Subscribe
    public void onReceiveFilePause(IMProxyFileEvent.ReceiveFilePausedEvent event) {
        LogUtil.d("EVENT: Receive file pause.");
        int position = this.mathMessage(event.getAttachedMsgId());
        if (position < 0) {
            LogUtil.w("Error: Receive file PAUSE, position: " + position);
            return;
        }
        FileInfo fileInfo = this.mMessageList.get(position).getFileInfo();
        if (fileInfo == null) {
            LogUtil.e("ERROR: Receive file PAUSE, but post fileInfo is null.");
            return;
        }
        if (event.getFileInfo() != null) {
            fileInfo.setTranslateSize(event.getFileInfo().getTranslateSize());
        }
        fileInfo.setFileState(4);
        this.updateFileInfo(position, fileInfo);
    }

    @Subscribe
    public void onReceiveFileProgressUpdate(IMProxyFileEvent.ReceiveFileProgressUpdateEvent event) {
        LogUtil.d("EVENT: Receive file progress update.");
        int position = this.mathMessage(event.getAttachedMsgId());
        if (position < 0) {
            LogUtil.w("Error: Send file progress update, position: " + position);
            return;
        }
        FileInfo fileInfo = this.mMessageList.get(position).getFileInfo();
        if (fileInfo == null) {
            LogUtil.e("ERROR: Send file progress update, but post fileInfo is null.");
            return;
        }
        if (fileInfo.getFileType() != 11) {
            LogUtil.d("No need update file progress.");
            return;
        }
        if (event.getFileInfo() != null) {
            fileInfo.setTranslateSize(event.getFileInfo().getTranslateSize());
        }
        fileInfo.setFileState(3);
        this.updateFileInfo(position, fileInfo);
    }

    @Subscribe
    public void onReceiveFileFailed(IMProxyFileEvent.ReceiveFileFailedEvent event) {
        LogUtil.d("EVENT: Receive file failed.");
        int position = this.mathMessage(event.getAttachedMsgId());
        if (position < 0) {
            LogUtil.w("Error: Receive file Failed, position: " + position);
            return;
        }
        FileInfo fileInfo = this.mMessageList.get(position).getFileInfo();
        if (fileInfo == null) {
            LogUtil.e("ERROR: Receive file Failed, but post fileInfo is null.");
            return;
        }
        if (event.getFileInfo() != null) {
            fileInfo.setTranslateSize(event.getFileInfo().getTranslateSize());
        }
        fileInfo.setFileState(5);
        this.updateFileInfo(position, fileInfo);
        TranslateInfoUtil.remove(fileInfo.getTalkMessageId());
    }

    @Subscribe
    public void onRefreshGroupEvent(IMContactEvent.RefreshGroupEvent event) {
        LogUtil.d("EVENT: Refresh group.");
        if (!this.mTalkId.equals(event.getAccount())) {
            LogUtil.d("No Need to refresh current chat list.");
            return;
        }
    }

    @Subscribe
    public void onDissolutionGroupEvent(IMContactEvent.DissolutionGroupEvent event) {
        LogUtil.d("EVENT: Dissolution current group.");
        IMProxySessionEvent.DeleteSessionEvent deleteSessionEvent = new IMProxySessionEvent.DeleteSessionEvent();
        TalkSessionBean talkSessionBean = new TalkSessionBean();
        talkSessionBean.setTalkerAccount(this.mTalkId);
        talkSessionBean.setTalkType(2);
        deleteSessionEvent.setSessionBean(talkSessionBean);
        BusProvider.getInstance().post(deleteSessionEvent);
        this.finish();
    }

    private int mathMessage(long messageId) {
        int size = this.mMessageList.size();
        for (int i = size - 1; i >= 0; --i) {
            if (messageId != this.mMessageList.get(i).getId()) continue;
            return i;
        }
        return -1;
    }

    private void updateFileInfo(int position, FileInfo fileInfo) {
        if (position < 0 || position > this.mMessageList.size()) {
            return;
        }
        this.mMessageList.get(position).setFileInfo(fileInfo);
        this.mAdapter.updateItem(position, this.mMessageList.get(position));
    }

    @Override
    public void playingCallback(String filePath, Object ... args) {
        if (TextUtils.isEmpty((CharSequence)filePath) && (args == null || args.length == 0)) {
            return;
        }
        long msgId = (Long)args[0];
        this.mAdapter.startAnimation(filePath, msgId);
    }

    @Override
    public void playingStopCallback(String filePath, Object ... args) {
        if (TextUtils.isEmpty((CharSequence)filePath) && (args == null || args.length == 0)) {
            return;
        }
        long msgId = (Long)args[0];
        this.mAdapter.stopAnimation(filePath, msgId);
    }

    @Override
    public void playingErrorCallback(String filePath, Object ... args) {
        if (TextUtils.isEmpty((CharSequence)filePath) && (args == null || args.length == 0)) {
            return;
        }
        long msgId = (Long)args[0];
        this.mAdapter.stopAnimation(filePath, msgId);
    }

    @Override
    public void playingCompletionCallback(String filePath, Object ... args) {
        if (TextUtils.isEmpty((CharSequence)filePath) && (args == null || args.length == 0)) {
            return;
        }
        long msgId = (Long)args[0];
        boolean isNext = (Boolean)args[1];
        this.mAdapter.playNextAudio(filePath, msgId, isNext);
    }
}

