/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.ui.view;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;
import com.xdja.im.base.frame.view.AdapterBaseView;
import com.xdja.im.base.frame.view.AdapterSuperBaseView;
import com.xdja.im.core.model.account.AccountBean;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.utils.DataCache;
import com.xdja.im.core.utils.ToolUtils;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.ui.presenter.ChatListAdapterPresenter;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.im.uikit.utils.sys.TimeUtil;
import com.xdja.im.uikit.view.BaseListDialog;
import com.xdja.im.uikit.view.CircleImageView;
import rx.Subscriber;

public class BaseChatItem
extends AdapterSuperBaseView<ChatListAdapterPresenter, TalkMessageBean>
implements AdapterBaseView<ChatListAdapterPresenter, TalkMessageBean> {
    public static final long TIME_DIFFERENCE = 300000L;
    private CircleImageView mUserHeader;
    private TextView mTimeLineTv;
    protected BaseListDialog mPopDialog;
    private CharSequence[] mPopItemData;

    @Override
    protected void injectView() {
        super.injectView();
        this.mUserHeader = (CircleImageView)this.findViewById(R.id.img_user_icon);
        this.mTimeLineTv = (TextView)this.findViewById(R.id.tv_timeLine);
        this.mPopDialog = new BaseListDialog(this.getContext()){

            @Override
            public CharSequence[] getOptions() {
                return BaseChatItem.access$002(BaseChatItem.this, BaseChatItem.this.getResources().getStringArray(R.array.chat_options));
            }
        };
        this.mUserHeader.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (((TalkMessageBean)BaseChatItem.this.dataSource).isMine()) {
                    return;
                }
                String account = ((TalkMessageBean)BaseChatItem.this.dataSource).getFrom();
                if (TextUtils.isEmpty((CharSequence)account)) {
                    LogUtil.e("ERROR: User account is null.");
                    return;
                }
                LogUtil.d("Start open user setting.(" + account + ")");
                ((ChatListAdapterPresenter)BaseChatItem.this.getPresenter()).openSetting(account);
            }
        });
    }

    @Override
    public void bindDataSource(int position, @NonNull TalkMessageBean dataSource) {
        super.bindDataSource(position, dataSource);
        if (position == 0) {
            this.setTimeLineVisible(dataSource.getShowTime());
        } else {
            TalkMessageBean lastMessage = ((ChatListAdapterPresenter)this.getPresenter()).getTalkMessage(this.curPosition - 1);
            if (lastMessage != null && dataSource.getShowTime() - lastMessage.getShowTime() > 300000L) {
                this.mTimeLineTv.setVisibility(0);
                this.mTimeLineTv.setText((CharSequence)TimeUtil.convertTimeLine(dataSource.getShowTime()));
            } else {
                this.mTimeLineTv.setVisibility(8);
            }
        }
        if (dataSource.getMessageType() == 101) {
            return;
        }
        try {
            this.loadUserData();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setTimeLineVisible(long time) {
        this.mTimeLineTv.setVisibility(0);
        this.mTimeLineTv.setText((CharSequence)TimeUtil.convertTimeLine(time));
    }

    protected int getNormalTextColor() {
        return -16777216;
    }

    protected int getLimitTextColor() {
        return -3355444;
    }

    public CharSequence[] getPopItemData() {
        CharSequence[] data = ((TalkMessageBean)this.dataSource).isMine() ? (((TalkMessageBean)this.dataSource).getMessageType() == 0 ? new CharSequence[]{this.mPopItemData[0], this.mPopItemData[1]} : new CharSequence[]{this.mPopItemData[0]}) : (((TalkMessageBean)this.dataSource).getMessageType() == 0 && ((TalkMessageBean)this.dataSource).getMessageState() != 5 ? new CharSequence[]{this.mPopItemData[0], this.mPopItemData[1]} : new CharSequence[]{this.mPopItemData[0]});
        return data;
    }

    protected void loadUserData() {
        final String account = ((TalkMessageBean)this.dataSource).getFrom();
        if (TextUtils.isEmpty((CharSequence)account)) {
            return;
        }
        int talkType = ((TalkMessageBean)this.dataSource).isGroupMsg() ? 2 : 1;
        String sessionFlag = ToolUtils.getSessionTag(account, talkType);
        AccountBean accountBean = (AccountBean)DataCache.getInstance().get(sessionFlag);
        if (accountBean != null && !TextUtils.isEmpty((CharSequence)accountBean.getAvatarUrl())) {
            this.mUserHeader.loadImage(accountBean.getAvatarUrl(), true, R.mipmap.im_uikit_user_header_40dp);
            return;
        }
        ((ChatListAdapterPresenter)this.getPresenter()).getAccount(account, talkType, new Subscriber<AccountBean>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                LogUtil.w("ERROR: get account failed." + account);
            }

            public void onNext(AccountBean accountBean) {
                if (accountBean == null || TextUtils.isEmpty((CharSequence)accountBean.getAvatarUrl())) {
                    return;
                }
                BaseChatItem.this.mUserHeader.loadImage(accountBean.getAvatarUrl(), true, R.mipmap.im_uikit_user_header_40dp);
            }
        });
    }

    static /* synthetic */ CharSequence[] access$002(BaseChatItem x0, CharSequence[] x1) {
        x0.mPopItemData = x1;
        return x1;
    }
}

