/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.ui.view;

import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.xdja.im.base.frame.view.FragmentSuperBaseView;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.ui.adapter.SessionListAdapter;
import com.xdja.im.uikit.ui.presenter.SessionListPresenter;
import com.xdja.im.uikit.ui.view.vu.SessionListVu;
import com.xdja.im.uikit.view.BaseListDialog;

public class ViewSessionList
extends FragmentSuperBaseView<SessionListPresenter>
implements SessionListVu {
    private ListView mChatSessionList;
    private ProgressBar mLoadingPBar;
    private TextView mEmptyHintTv;
    private BaseListDialog mPopDialog;
    private CharSequence[] mPopItemData;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_fragment_session_list;
    }

    @Override
    protected void injectView() {
        super.injectView();
        this.mChatSessionList = (ListView)this.findViewById(R.id.rv_session_list);
        this.mLoadingPBar = (ProgressBar)this.findViewById(R.id.pbar_loading);
        this.mEmptyHintTv = (TextView)this.findViewById(R.id.tv_empty);
        this.mChatSessionList.setEmptyView((View)this.mEmptyHintTv);
        this.mPopDialog = new BaseListDialog(this.getContext()){

            @Override
            public CharSequence[] getOptions() {
                return ViewSessionList.access$002(ViewSessionList.this, this.getContext().getResources().getStringArray(R.array.session_options));
            }
        };
        this.setListener();
    }

    private void setListener() {
        this.mChatSessionList.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                ((SessionListPresenter)ViewSessionList.this.getPresenter()).onListItemClick(position);
            }
        });
        this.mChatSessionList.setOnItemLongClickListener(new AdapterView.OnItemLongClickListener(){

            public boolean onItemLongClick(AdapterView<?> parent, View view, int position, long id2) {
                ViewSessionList.this.mPopDialog.addData(ViewSessionList.this.getPopItemData(position));
                ViewSessionList.this.mPopDialog.show(position);
                return true;
            }
        });
        this.mPopDialog.setOnItemClickListener(new BaseListDialog.onItemClickListener(){

            @Override
            public void onItemClick(View view, int position, int itemPosition) {
                switch (position) {
                    case 0: {
                        ((SessionListPresenter)ViewSessionList.this.getPresenter()).setSessionTop(itemPosition);
                        break;
                    }
                    case 1: {
                        ((SessionListPresenter)ViewSessionList.this.getPresenter()).deleteSession(itemPosition);
                        break;
                    }
                    case 2: {
                        ((SessionListPresenter)ViewSessionList.this.getPresenter()).setDisturb(itemPosition);
                    }
                }
                ViewSessionList.this.mPopDialog.dismiss();
            }
        });
    }

    @Override
    public void setAdapter(SessionListAdapter adapter) {
        this.mChatSessionList.setAdapter((ListAdapter)adapter);
        this.mEmptyHintTv.setVisibility(8);
    }

    @Override
    public void setProgressBarVisibility(int visibility) {
        this.mLoadingPBar.setVisibility(visibility);
    }

    public CharSequence[] getPopItemData(int position) {
        CharSequence[] data = new CharSequence[]{((SessionListPresenter)this.getPresenter()).isSessionTop(position) ? this.mPopItemData[1] : this.mPopItemData[0], this.mPopItemData[2], ((SessionListPresenter)this.getPresenter()).isDisturb(position) ? this.mPopItemData[4] : this.mPopItemData[3]};
        return data;
    }

    static /* synthetic */ CharSequence[] access$002(ViewSessionList x0, CharSequence[] x1) {
        x0.mPopItemData = x1;
        return x1;
    }
}

