/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.utils.sys;

import com.xdja.im.common.utils.CommonTool;
import com.xdja.im.common.utils.DateUtils;
import com.xdja.im.uikit.R;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public class TimeUtil {
    private static final String FORMAT_MDYHM = "yyyy/MM/dd HH:mm";
    private static final String FORMAT_MDHM = "MM/dd HH:mm";
    private static final String FORMAT_HHMM = "HH:mm";
    private static final Map<String, ThreadLocal<SimpleDateFormat>> sdfMap = new HashMap<String, ThreadLocal<SimpleDateFormat>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static SimpleDateFormat getFormat(final String pattern) {
        ThreadLocal<SimpleDateFormat> formatThread = sdfMap.get(pattern);
        if (formatThread != null) return formatThread.get();
        Class<DateUtils> clazz = DateUtils.class;
        synchronized (DateUtils.class) {
            formatThread = new ThreadLocal<SimpleDateFormat>(){

                @Override
                protected SimpleDateFormat initialValue() {
                    return new SimpleDateFormat(pattern);
                }
            };
            sdfMap.put(pattern, formatThread);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return formatThread.get();
        }
    }

    public static String convertTimeLine(long timestamp) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(System.currentTimeMillis());
        int currentYear = cal.get(1);
        int currentMonth = cal.get(2);
        int currentDay = cal.get(5);
        cal.setTimeInMillis(timestamp);
        int lastYear = cal.get(1);
        int lastMonth = cal.get(2);
        int lastDay = cal.get(5);
        String timeStr = currentYear == lastYear ? (currentMonth == lastMonth && currentDay == lastDay ? TimeUtil.getFormat(FORMAT_HHMM).format(timestamp) : (currentMonth == lastMonth && currentDay - lastDay == 1 ? String.format(CommonTool.getString(R.string.im_uikit_yesterday), TimeUtil.getFormat(FORMAT_HHMM).format(timestamp)) : TimeUtil.getFormat(FORMAT_MDHM).format(timestamp))) : TimeUtil.getFormat(FORMAT_MDYHM).format(timestamp);
        return timeStr;
    }
}

