/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import com.xdja.im.uikit.R;

public class CircleProgressBar
extends View {
    private int mRadius = -1;
    private int mMax = -1;
    private int mProgress = -1;
    private final Paint paint = new Paint();

    public CircleProgressBar(Context context) {
        this(context, null);
    }

    public CircleProgressBar(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CircleProgressBar(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray array2 = context.obtainStyledAttributes(attrs, R.styleable.CircleProgressBarStyle);
        this.mRadius = array2.getDimensionPixelSize(R.styleable.CircleProgressBarStyle_radius, -1);
        array2.recycle();
    }

    protected void onDraw(Canvas canvas) {
        if (this.mRadius != -1 && this.getVisibility() == 0) {
            this.paint.setAntiAlias(true);
            float angle = 0.0f;
            if (this.mMax > 0 && this.mProgress >= 0) {
                angle = (float)this.mProgress / (float)this.mMax * 360.0f;
            }
            this.paint.setColor(Color.argb((int)115, (int)255, (int)255, (int)255));
            RectF oval2 = new RectF(((float)this.getWidth() - (float)this.mRadius * 2.0f) / 2.0f, ((float)this.getHeight() - (float)this.mRadius * 2.0f) / 2.0f, (float)this.getWidth() - ((float)this.getWidth() - (float)this.mRadius * 2.0f) / 2.0f, (float)this.getHeight() - ((float)this.getHeight() - (float)this.mRadius * 2.0f) / 2.0f);
            canvas.drawArc(oval2, 270.0f, angle, true, this.paint);
        }
    }

    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (visibility == 0) {
            this.invalidate();
        }
    }

    public void setMax(int mMax) {
        this.mMax = mMax;
    }

    public void setProgress(int mProgress) {
        this.mProgress = mProgress;
        this.invalidate();
    }
}

