/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.view;

import android.content.ClipboardManager;
import android.content.Context;
import android.text.Editable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.ContextMenu;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputConnectionWrapper;
import android.widget.EditText;
import com.xdja.im.common.utils.CommonTool;
import com.xdja.im.lib.emoji.utils.EmotionUtils;
import com.xdja.im.uikit.R;

public class PastEditText
extends EditText {
    public static final int ID_PASTE = 0x1020022;
    public static final int ID_SELECTALL = 16908319;
    public static final int ID_COPY = 0x1020021;
    public static final int ID_CUT = 0x1020020;
    private final int maxLength = 2048;
    private final float FACE_SIZE = 1.1f;

    public PastEditText(Context context) {
        super(context);
    }

    public PastEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public PastEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void onCreateContextMenu(ContextMenu menu) {
        super.onCreateContextMenu(menu);
    }

    public boolean onTextContextMenuItem(int id2) {
        switch (id2) {
            case 0x1020022: {
                ClipboardManager cmb = (ClipboardManager)this.getContext().getSystemService("clipboard");
                if (cmb.getPrimaryClip() == null) break;
                String value = cmb.getText().toString();
                String preTxtStr = this.getText().toString();
                if (preTxtStr.length() + value.length() > 2048) {
                    value = value.substring(0, 2048 - preTxtStr.length());
                }
                if (TextUtils.isEmpty((CharSequence)value)) break;
                try {
                    SpannableString ss = EmotionUtils.formatSpanContent(value, this.getContext(), 1.1f);
                    if (!TextUtils.isEmpty((CharSequence)ss)) {
                        Editable edit = this.getEditableText();
                        edit.insert(this.getSelectionStart(), (CharSequence)ss);
                        this.setFocusable(true);
                        return false;
                    }
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                break;
            }
        }
        return super.onTextContextMenuItem(id2);
    }

    public InputConnection onCreateInputConnection(EditorInfo outAttrs) {
        return new ZanyInputConnection(super.onCreateInputConnection(outAttrs), true);
    }

    private class ZanyInputConnection
    extends InputConnectionWrapper {
        public ZanyInputConnection(InputConnection target, boolean mutable) {
            super(target, mutable);
        }

        public boolean deleteSurroundingText(int beforeLength, int afterLength) {
            return super.deleteSurroundingText(beforeLength, afterLength);
        }

        public boolean commitText(CharSequence text, int newCursorPosition) {
            int length = PastEditText.this.getText().length();
            if (length >= 2048) {
                CommonTool.showToast(R.string.im_uikit_input_length_warnning);
                return false;
            }
            if (EmotionUtils.mathEmotion(text.toString())) {
                Editable edit = PastEditText.this.getEditableText();
                SpannableString ss = EmotionUtils.formatSpanContent(text, PastEditText.this.getContext(), 1.1f);
                edit.insert(PastEditText.this.getSelectionStart(), (CharSequence)ss);
                return false;
            }
            return super.commitText(text, newCursorPosition);
        }
    }
}

