/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.view.slideback;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.view.slideback.ActivityHelper;
import com.xdja.im.uikit.view.slideback.SlideConfig;
import com.xdja.im.uikit.view.slideback.callbak.OnInternalStateListener;
import com.xdja.im.uikit.view.slideback.callbak.OnSlideListener;
import com.xdja.im.uikit.view.slideback.widget.SlideBackLayout;

public class SlideBackHelper {
    public static ViewGroup getDecorView(Activity activity) {
        return (ViewGroup)activity.getWindow().getDecorView();
    }

    public static Drawable getDecorViewDrawable(Activity activity) {
        return SlideBackHelper.getDecorView(activity).getBackground();
    }

    public static View getContentView(Activity activity) {
        return SlideBackHelper.getDecorView(activity).getChildAt(0);
    }

    public static SlideBackLayout attach(final @NonNull Activity curActivity, final @NonNull ActivityHelper helper, final @Nullable SlideConfig config, final @Nullable OnSlideListener listener) {
        ViewGroup decorView = SlideBackHelper.getDecorView(curActivity);
        final View contentView = decorView.getChildAt(0);
        decorView.removeViewAt(0);
        View content = contentView.findViewById(0x1020002);
        if (content.getBackground() == null) {
            content.setBackground(decorView.getBackground());
        }
        final Activity[] preActivity = new Activity[]{helper.getPreActivity()};
        final View[] preContentView = new View[]{SlideBackHelper.getContentView(preActivity[0])};
        Drawable preDecorViewDrawable = SlideBackHelper.getDecorViewDrawable(preActivity[0]);
        content = preContentView[0].findViewById(0x1020002);
        if (content.getBackground() == null) {
            content.setBackground(preDecorViewDrawable);
        }
        SlideBackLayout slideBackLayout = new SlideBackLayout((Context)curActivity, contentView, preContentView[0], preDecorViewDrawable, config, new OnInternalStateListener(){

            @Override
            public void onSlide(float percent) {
                if (listener != null) {
                    listener.onSlide(percent);
                }
            }

            @Override
            public void onOpen() {
                if (listener != null) {
                    listener.onOpen();
                }
            }

            @Override
            public void onClose(Boolean finishActivity) {
                if (listener != null) {
                    listener.onClose();
                }
                if (!(finishActivity != null && finishActivity.booleanValue() || listener == null)) {
                    listener.onClose();
                }
                if (config != null && config.isRotateScreen()) {
                    if (finishActivity != null && finishActivity.booleanValue()) {
                        contentView.setVisibility(4);
                    }
                    if (preActivity[0] != null && preContentView[0].getParent() != SlideBackHelper.getDecorView(preActivity[0])) {
                        preContentView[0].setX(0.0f);
                        ((ViewGroup)preContentView[0].getParent()).removeView(preContentView[0]);
                        SlideBackHelper.getDecorView(preActivity[0]).addView(preContentView[0], 0);
                    }
                }
                if (finishActivity != null && finishActivity.booleanValue()) {
                    curActivity.finish();
                    curActivity.overridePendingTransition(0, R.anim.anim_out_none);
                    helper.postRemoveActivity(curActivity);
                } else if (finishActivity == null) {
                    helper.postRemoveActivity(curActivity);
                }
            }

            @Override
            public void onCheckPreActivity(SlideBackLayout slideBackLayout) {
                Activity activity = helper.getPreActivity();
                if (activity != preActivity[0]) {
                    preActivity[0] = activity;
                    preContentView[0] = SlideBackHelper.getContentView(preActivity[0]);
                    slideBackLayout.updatePreContentView(preContentView[0]);
                }
            }
        });
        decorView.addView((View)slideBackLayout);
        return slideBackLayout;
    }
}

