/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.view.slideback;

import android.support.annotation.FloatRange;

public class SlideConfig {
    private boolean mEdgeOnly;
    private boolean mLock;
    @FloatRange(from=0.0, to=1.0)
    private float mEdgePercent;
    @FloatRange(from=0.0, to=1.0)
    private float mSlideOutPercent;
    private float mSlideOutVelocity;
    private boolean mRotateScreen;

    public boolean isEdgeOnly() {
        return this.mEdgeOnly;
    }

    public boolean isLock() {
        return this.mLock;
    }

    public float getEdgePercent() {
        return this.mEdgePercent;
    }

    public float getSlideOutPercent() {
        return this.mSlideOutPercent;
    }

    public float getSlideOutVelocity() {
        return this.mSlideOutVelocity;
    }

    public boolean isRotateScreen() {
        return this.mRotateScreen;
    }

    private SlideConfig() {
    }

    public SlideConfig(Builder builder) {
        this.mEdgeOnly = builder.edgeOnly;
        this.mLock = builder.lock;
        this.mEdgePercent = builder.edgePercent;
        this.mSlideOutPercent = builder.slideOutPercent;
        this.mSlideOutVelocity = builder.slideOutVelocity;
        this.mRotateScreen = builder.rotateScreen;
    }

    public static class Builder {
        private boolean edgeOnly = false;
        private boolean lock = false;
        @FloatRange(from=0.0, to=1.0)
        private float edgePercent = 0.4f;
        @FloatRange(from=0.0, to=1.0)
        private float slideOutPercent = 0.1f;
        private float slideOutVelocity = 2000.0f;
        private boolean rotateScreen = false;

        public SlideConfig create() {
            return new SlideConfig(this);
        }

        public Builder edgeOnly(boolean edgeOnly) {
            this.edgeOnly = edgeOnly;
            return this;
        }

        public Builder lock(boolean lock) {
            this.lock = lock;
            return this;
        }

        public Builder slideOutVelocity(float slideOutVelocity) {
            this.slideOutVelocity = slideOutVelocity;
            return this;
        }

        public Builder edgePercent(@FloatRange(from=0.0, to=1.0) float edgePercent) {
            this.edgePercent = edgePercent;
            return this;
        }

        public Builder slideOutPercent(@FloatRange(from=0.0, to=1.0) float slideOutPercent) {
            this.slideOutPercent = slideOutPercent;
            return this;
        }

        public Builder rotateScreen(boolean rotateScreen) {
            this.rotateScreen = rotateScreen;
            return this;
        }
    }
}

