/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.view.slideback.widget;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.support.annotation.FloatRange;
import android.view.View;

public class ShadowView
extends View {
    private LinearGradient mLinearGradient;
    private Paint mPaint = new Paint();
    private RectF mRectF;
    private float mAlphaPercent = -1.0f;

    public ShadowView(Context context) {
        super(context);
    }

    protected void onDraw(Canvas canvas) {
        if (this.mAlphaPercent >= 0.0f) {
            if (this.mLinearGradient == null) {
                this.mRectF = new RectF();
                int[] colors = new int[]{Color.parseColor((String)"#0A000000"), Color.parseColor((String)"#66000000"), Color.parseColor((String)"#aa000000")};
                this.mLinearGradient = new LinearGradient(0.0f, 0.0f, (float)this.getWidth(), 0.0f, colors, null, Shader.TileMode.REPEAT);
                this.mPaint.setShader((Shader)this.mLinearGradient);
                this.mRectF.set(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
            }
            this.mPaint.setAlpha((int)(this.mAlphaPercent * 255.0f));
            canvas.drawRect(this.mRectF, this.mPaint);
        }
    }

    public void redraw(@FloatRange(from=0.0, to=1.0) float alphaPercent) {
        this.mAlphaPercent = alphaPercent;
        this.invalidate();
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.mLinearGradient = null;
    }
}

