/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.view.slideback.widget;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.drawable.Drawable;
import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import android.support.v4.view.ViewGroupCompat;
import android.support.v4.widget.ViewDragHelper;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import com.xdja.im.uikit.view.slideback.SlideConfig;
import com.xdja.im.uikit.view.slideback.callbak.OnInternalStateListener;
import com.xdja.im.uikit.view.slideback.widget.CacheDrawView;
import com.xdja.im.uikit.view.slideback.widget.ShadowView;

public class SlideBackLayout
extends FrameLayout {
    private static final int MIN_FLING_VELOCITY = 400;
    private final String mTestName;
    private boolean mCheckPreContentView;
    private boolean mIsFirstAttachToWindow;
    private ViewDragHelper mDragHelper;
    private View mContentView;
    private CacheDrawView mCacheDrawView;
    private ShadowView mShadowView;
    private View mPreContentView;
    private Drawable mPreDecorViewDrawable;
    private int mScreenWidth;
    private boolean mEdgeOnly = false;
    private boolean mLock = false;
    @FloatRange(from=0.0, to=1.0)
    private float mSlideOutRangePercent = 0.4f;
    @FloatRange(from=0.0, to=1.0)
    private float mEdgeRangePercent = 0.1f;
    private float mSlideOutRange;
    private float mEdgeRange;
    private float mSlideOutVelocity;
    private boolean mIsEdgeRangeInside;
    private OnInternalStateListener mOnInternalStateListener;
    private float mDownX;
    private float mSlidDistantX;
    private boolean mRotateScreen;
    private boolean mCloseFlagForWindowFocus;
    private boolean mCloseFlagForDetached;
    private boolean mEnableTouchEvent;

    public SlideBackLayout(Context context, View contentView, View preContentView, Drawable preDecorViewDrawable, SlideConfig config, @NonNull OnInternalStateListener onInternalStateListener) {
        super(context);
        this.mContentView = contentView;
        this.mPreContentView = preContentView;
        this.mPreDecorViewDrawable = preDecorViewDrawable;
        this.mOnInternalStateListener = onInternalStateListener;
        this.initConfig(config);
        this.mTestName = preContentView instanceof LinearLayout ? "1\u53f7\u6ed1\u52a8" : "2\u53f7\u6ed1\u52a8";
    }

    private void initConfig(SlideConfig config) {
        if (config == null) {
            config = new SlideConfig.Builder().create();
        }
        this.mScreenWidth = this.getResources().getDisplayMetrics().widthPixels;
        float density = this.getResources().getDisplayMetrics().density;
        float minVel = 400.0f * density;
        ViewGroupCompat.setMotionEventSplittingEnabled((ViewGroup)this, (boolean)false);
        SlideLeftCallback slideLeftCallback = new SlideLeftCallback();
        this.mDragHelper = ViewDragHelper.create((ViewGroup)this, (float)1.0f, (ViewDragHelper.Callback)slideLeftCallback);
        this.mDragHelper.setMinVelocity(minVel);
        this.mDragHelper.setEdgeTrackingEnabled(1);
        this.mCacheDrawView = new CacheDrawView(this.getContext());
        this.mCacheDrawView.setVisibility(4);
        this.addView(this.mCacheDrawView);
        this.mShadowView = new ShadowView(this.getContext());
        this.mShadowView.setVisibility(4);
        this.addView(this.mShadowView, this.mScreenWidth / 28, -1);
        this.addView(this.mContentView);
        this.mEdgeOnly = config.isEdgeOnly();
        this.mLock = config.isLock();
        this.mRotateScreen = config.isRotateScreen();
        this.mSlideOutRangePercent = config.getSlideOutPercent();
        this.mEdgeRangePercent = config.getEdgePercent();
        this.mSlideOutRange = (float)this.mScreenWidth * this.mSlideOutRangePercent;
        this.mEdgeRange = (float)this.mScreenWidth * this.mEdgeRangePercent;
        this.mSlideOutVelocity = config.getSlideOutVelocity();
        this.mSlidDistantX = (float)this.mScreenWidth / 20.0f;
        this.mContentView.setFitsSystemWindows(false);
        if (this.mRotateScreen) {
            this.mContentView.findViewById(0x1020002).setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                }
            });
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.mDownX = event.getX();
                break;
            }
            case 2: {
                if (!(event.getX() - this.mDownX < this.mSlidDistantX)) break;
                return false;
            }
        }
        if (this.mLock) {
            return false;
        }
        if (this.mEdgeOnly) {
            float x = event.getX();
            this.mIsEdgeRangeInside = this.isEdgeRangeInside(x);
            return this.mIsEdgeRangeInside && this.mDragHelper.shouldInterceptTouchEvent(event);
        }
        return this.mDragHelper.shouldInterceptTouchEvent(event);
    }

    private boolean isEdgeRangeInside(float x) {
        return x <= this.mEdgeRange;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mLock) {
            return super.onTouchEvent(event);
        }
        if (!this.mEdgeOnly || this.mIsEdgeRangeInside) {
            if (!this.mEnableTouchEvent) {
                return super.onTouchEvent(event);
            }
            if (this.mCloseFlagForDetached || this.mCloseFlagForWindowFocus) {
                return super.onTouchEvent(event);
            }
        } else {
            return super.onTouchEvent(event);
        }
        this.mDragHelper.processTouchEvent(event);
        return true;
    }

    private void addPreContentView() {
        if (this.mPreContentView.getParent() != this) {
            this.mPreContentView.setTag((Object)"notScreenOrientationChange");
            ((ViewGroup)this.mPreContentView.getParent()).removeView(this.mPreContentView);
            this.addView(this.mPreContentView, 0);
            this.mShadowView.setVisibility(0);
        }
    }

    public void computeScroll() {
        if (this.mDragHelper.continueSettling(true)) {
            this.invalidate();
        }
    }

    public void isComingToFinish() {
        if (this.mRotateScreen) {
            this.mCloseFlagForDetached = true;
            this.mCloseFlagForWindowFocus = false;
            this.mOnInternalStateListener.onClose(null);
            this.mPreContentView.setX(0.0f);
        }
    }

    public String getTestName() {
        return this.mTestName;
    }

    public void updatePreContentView(View contentView) {
        this.mPreContentView = contentView;
        this.mCacheDrawView.drawCacheView(this.mPreContentView);
    }

    public void edgeOnly(boolean edgeOnly) {
        this.mEdgeOnly = edgeOnly;
    }

    public boolean isEdgeOnly() {
        return this.mEdgeOnly;
    }

    public void lock(boolean lock) {
        this.mLock = lock;
    }

    public boolean isLock() {
        return this.mLock;
    }

    public void setSlideOutRangePercent(float slideOutRangePercent) {
        this.mSlideOutRangePercent = slideOutRangePercent;
        this.mSlideOutRange = (float)this.mScreenWidth * this.mSlideOutRangePercent;
    }

    public float getSlideOutRangePercent() {
        return this.mSlideOutRangePercent;
    }

    public void setEdgeRangePercent(float edgeRangePercent) {
        this.mEdgeRangePercent = edgeRangePercent;
        this.mEdgeRange = (float)this.mScreenWidth * this.mEdgeRangePercent;
    }

    public float getEdgeRangePercent() {
        return this.mEdgeRangePercent;
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        if (hasWindowFocus) {
            this.mEnableTouchEvent = true;
            if (!this.mIsFirstAttachToWindow) {
                this.mIsFirstAttachToWindow = true;
            }
        } else if (this.mRotateScreen) {
            if (this.mCloseFlagForWindowFocus) {
                this.mCloseFlagForWindowFocus = false;
            } else {
                this.mOnInternalStateListener.onClose(false);
            }
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mEnableTouchEvent = false;
        if (this.mRotateScreen) {
            if (this.mCloseFlagForDetached) {
                this.mCloseFlagForDetached = false;
            } else if (this.getTag() != null && this.getTag().equals("notScreenOrientationChange")) {
                this.setTag(null);
            } else {
                this.mOnInternalStateListener.onClose(false);
            }
        }
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.mScreenWidth = this.getResources().getDisplayMetrics().widthPixels;
        ViewGroup.LayoutParams layoutParams = this.mShadowView.getLayoutParams();
        layoutParams.width = this.mScreenWidth / 28;
        layoutParams.height = -1;
    }

    class SlideLeftCallback
    extends ViewDragHelper.Callback {
        SlideLeftCallback() {
        }

        public boolean tryCaptureView(View child, int pointerId) {
            return child == SlideBackLayout.this.mContentView;
        }

        public int clampViewPositionHorizontal(View child, int left, int dx) {
            return Math.max(Math.min(SlideBackLayout.this.mScreenWidth, left), 0);
        }

        public int getViewHorizontalDragRange(View child) {
            return SlideBackLayout.this.mScreenWidth;
        }

        public void onViewReleased(View releasedChild, float xvel, float yvel) {
            if (releasedChild == SlideBackLayout.this.mContentView) {
                if (xvel > SlideBackLayout.this.mSlideOutVelocity) {
                    SlideBackLayout.this.mDragHelper.settleCapturedViewAt(SlideBackLayout.this.mScreenWidth, 0);
                    SlideBackLayout.this.invalidate();
                    return;
                }
                if ((float)SlideBackLayout.this.mContentView.getLeft() < SlideBackLayout.this.mSlideOutRange) {
                    SlideBackLayout.this.mDragHelper.settleCapturedViewAt(0, 0);
                } else {
                    SlideBackLayout.this.mDragHelper.settleCapturedViewAt(SlideBackLayout.this.mScreenWidth, 0);
                }
                SlideBackLayout.this.invalidate();
            }
        }

        public void onViewDragStateChanged(int state) {
            switch (state) {
                case 0: {
                    if (SlideBackLayout.this.mContentView.getLeft() == 0) {
                        SlideBackLayout.this.mOnInternalStateListener.onOpen();
                        break;
                    }
                    if (SlideBackLayout.this.mContentView.getLeft() != SlideBackLayout.this.mScreenWidth) break;
                    if (SlideBackLayout.this.mRotateScreen && SlideBackLayout.this.mCacheDrawView.getVisibility() == 4) {
                        SlideBackLayout.this.mCacheDrawView.setBackground(SlideBackLayout.this.mPreDecorViewDrawable);
                        SlideBackLayout.this.mCacheDrawView.drawCacheView(SlideBackLayout.this.mPreContentView);
                        SlideBackLayout.this.mCacheDrawView.setVisibility(0);
                        SlideBackLayout.this.mCloseFlagForWindowFocus = true;
                        SlideBackLayout.this.mCloseFlagForDetached = true;
                        SlideBackLayout.this.mPreContentView.setTag((Object)"notScreenOrientationChange");
                        SlideBackLayout.this.mOnInternalStateListener.onClose(true);
                        SlideBackLayout.this.mPreContentView.postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                SlideBackLayout.this.mCacheDrawView.setBackground(SlideBackLayout.this.mPreDecorViewDrawable);
                                SlideBackLayout.this.mCacheDrawView.drawCacheView(SlideBackLayout.this.mPreContentView);
                            }
                        }, 10L);
                        break;
                    }
                    if (SlideBackLayout.this.mRotateScreen) break;
                    SlideBackLayout.this.mCloseFlagForWindowFocus = true;
                    SlideBackLayout.this.mCloseFlagForDetached = true;
                    SlideBackLayout.this.mOnInternalStateListener.onClose(true);
                    break;
                }
            }
        }

        public void onViewPositionChanged(View changedView, int left, int top, int dx, int dy) {
            if (!SlideBackLayout.this.mRotateScreen && SlideBackLayout.this.mCacheDrawView.getVisibility() == 4) {
                SlideBackLayout.this.mCacheDrawView.setBackground(SlideBackLayout.this.mPreDecorViewDrawable);
                SlideBackLayout.this.mCacheDrawView.drawCacheView(SlideBackLayout.this.mPreContentView);
                SlideBackLayout.this.mCacheDrawView.setVisibility(0);
            } else if (SlideBackLayout.this.mRotateScreen) {
                if (!SlideBackLayout.this.mCheckPreContentView) {
                    SlideBackLayout.this.mCheckPreContentView = true;
                    SlideBackLayout.this.mOnInternalStateListener.onCheckPreActivity(SlideBackLayout.this);
                }
                SlideBackLayout.this.addPreContentView();
            }
            if (SlideBackLayout.this.mShadowView.getVisibility() != 0) {
                SlideBackLayout.this.mShadowView.setVisibility(0);
            }
            float percent = (float)left * 1.0f / (float)SlideBackLayout.this.mScreenWidth;
            SlideBackLayout.this.mOnInternalStateListener.onSlide(percent);
            if (SlideBackLayout.this.mRotateScreen) {
                SlideBackLayout.this.mPreContentView.setX((float)(-SlideBackLayout.this.mScreenWidth / 2) + percent * (float)(SlideBackLayout.this.mScreenWidth / 2));
            } else {
                SlideBackLayout.this.mCacheDrawView.setX((float)(-SlideBackLayout.this.mScreenWidth / 2) + percent * (float)(SlideBackLayout.this.mScreenWidth / 2));
            }
            SlideBackLayout.this.mShadowView.setX(SlideBackLayout.this.mContentView.getX() - (float)SlideBackLayout.this.mShadowView.getWidth());
            SlideBackLayout.this.mShadowView.redraw(1.0f - percent);
        }
    }
}

