package com.xdja.im.base.di.module;

import android.app.Activity;
import android.content.Context;

import com.xdja.im.base.di.DiConfig;
import com.xdja.im.base.di.scope.Scoped;

import dagger.Module;
import dagger.Provides;

/**
 * @Package:com.sontak.mvpmodel.di.module
 * @Author:Lei
 * @Creation:2017-03-20 23:29
 * @Version 1.0
 * @Description:
 */
@Module
public class ActivityModule {

    private final Activity activity;

    public ActivityModule(Activity activity) {
        this.activity = activity;
    }

    @Scoped(DiConfig.CONTEXT_SCOPE_ACTIVITY)
    @Provides
    public Context provideContext() {
        return activity;
    }
}
