package com.xdja.im.base.frame.presenter;

import android.app.Activity;
import android.support.annotation.NonNull;
import android.support.v4.view.PagerAdapter;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.xdja.im.base.frame.Presenter;
import com.xdja.im.base.frame.view.PagerAdapterView;
import com.xdja.im.uikit.ui.view.BaseFilePreview;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @Package: com.xdja.im.base.frame.presenter
 * @Author: xdjaxa
 * @Creation: 2017-04-18 13:58
 * @Version V1.0
 * @Description:
 */
public abstract class BasePagerAdapterPresenter<P extends Presenter, D> extends PagerAdapter {
    public Map<Integer,BaseFilePreview> adapterVus = new ConcurrentHashMap<>();
    @Override
    public boolean isViewFromObject(View view, Object object) {
        return view == object;
    }

    @Override
    public Object instantiateItem(ViewGroup container, int position) {
        PagerAdapterView<P, D> adapterVu = null;
        View convertView = null;
        int itemViewType = getItemViewType(position);
        Class<? extends PagerAdapterView> aClass = getVuClassByViewType(itemViewType);
        try {
            if (aClass != null) {
                adapterVu = aClass.newInstance();
                adapterVu.setPresenter(getPresenter());
                adapterVu.setActivity(getActivity());

                adapterVu.init(LayoutInflater.from(container.getContext()), container);
                convertView = adapterVu.getView();
                container.addView(convertView);

                adapterVu.bindDataSource(position, getDataSource(position));
                adapterVus.put(position, (BaseFilePreview) adapterVu);
            } else {
                throw new NullPointerException("item view type error!");
            }
        } catch (InstantiationException e) {
            e.printStackTrace();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return convertView;
    }

    @Override
    public void destroyItem(ViewGroup container, int position, Object object) {
        container.removeView((View) object);
        adapterVus.remove(position);
    }

    public abstract int getItemViewType(int position);

    protected abstract List<Class<? extends PagerAdapterView<P, D>>> getVuClasses();

    protected abstract P getPresenter();

    protected abstract D getDataSource(int position);

    /**
     * 根据View类型获取对应的View类型定义
     *
     * @return View类型
     */
    @NonNull
    protected Class<? extends PagerAdapterView<P, D>> getVuClassByViewType(int itemViewType) {
        if (this.getVuClasses() != null) {
            if (itemViewType < this.getVuClasses().size()) {
                return this.getVuClasses().get(itemViewType);
            }
        }
        return null;
    }

    protected Activity getActivity() {
        return null;
    }

    public abstract void onPageSelected(int lastPos, int curPos);
}
