package com.xdja.im.common.cache.interf;

import com.xdja.im.common.cache.entity.UserEntity;

/**
 * @Package: com.xdja.im.common.cache.interf
 * @Author: xdjaxa
 * @Creation: 2017-05-04 15:51
 * @Version V1.0
 * @Description:
 */
public interface UserCache {

    /**
     * 设置User信息
     *
     * @param userEntity 账号信息
     */
    void put(UserEntity userEntity);

    /**
     * 获取User信息
     *
     * @return 目标User信息
     */
    UserEntity get();

    /**
     * 匹配某个用户是否为当前用户
     *
     * @param account 待匹配用户
     * @return 匹配结果
     */
    boolean isMine(String account);
}
