package com.xdja.im.common.database;

import android.content.Context;
import android.content.ContextWrapper;
import android.database.DatabaseErrorHandler;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;

import com.xdja.im.common.utils.CachePath;

import java.io.File;
import java.io.IOException;

/**
 * @Package: com.xdja.im.common.database
 * @Author: xdjaxa
 * @Creation: 2017-05-22 18:17
 * @Version V1.0
 * @Description:
 */
public class DBContext extends ContextWrapper {

    private Context context;
    private String account;

    public DBContext(Context context, String account) {
        super(context);
        this.context = context;
        this.account = account;
    }

    @Override
    public File getDatabasePath(String name) {
        File dir;
        File file;

        if (context == null || TextUtils.isEmpty(name)) {
            return null;
        }
        String dirBuilder = CachePath.getParentDbPath() +
                File.separator +
                account;

        dir = new File(dirBuilder);
        file = new File(dir, name);

        boolean mkDir = false;
        if (!dir.exists()) {
            mkDir = dir.mkdirs();
        }

        if (mkDir && !file.exists()) {
            try {
                if (file.createNewFile()) {
                    return file;
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return file;
    }

    @Override
    public SQLiteDatabase openOrCreateDatabase(String name, int mode, SQLiteDatabase.CursorFactory factory,
                                               DatabaseErrorHandler errorHandler) {
        SQLiteDatabase result;
        if (context == null || TextUtils.isEmpty(name)) {
            return null;
        }
        result = SQLiteDatabase.openOrCreateDatabase(getDatabasePath(name), factory);
        return result;
    }

    @Override
    public SQLiteDatabase openOrCreateDatabase(String name, int mode,
                                               SQLiteDatabase.CursorFactory factory) {
        SQLiteDatabase result;
        if (context == null || TextUtils.isEmpty(name)) {
            return null;
        }
        result = SQLiteDatabase.openOrCreateDatabase(getDatabasePath(name), factory);
        return result;
    }
}
