package com.xdja.im.core.config;

import android.support.annotation.IntDef;
import android.view.View;

import com.xdja.im.common.utils.CommonTool;
import com.xdja.im.uikit.R;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * @Package: com.xdja.im.core.model
 * @Author: xdjaxa
 * @Creation: 2017-04-11 14:39
 * @Version V1.0
 * @Description:
 */
public class ConstDef {
    //***************************************************************
    //                     sdk初始化状态
    //***************************************************************
    @Retention(RetentionPolicy.SOURCE)
    @IntDef(value = {UNDO, COMPLETED, PROGRESSING, CANCELED, FAILED})
    public @interface InitState {
    }

    /**
     * 初始化未开始
     */
    public static final int UNDO = 1;
    /**
     * 初始化完成
     */
    public static final int COMPLETED = 2;
    /**
     * 进行中
     */
    public static final int PROGRESSING = 3;
    /**
     * 取消
     */
    public static final int CANCELED = 4;
    /**
     * 失败
     */
    public static final int FAILED = 5;

    //***************************************************************
    //                     消息状态类型定义
    //***************************************************************

    /**
     * 将消息状态转化为对应的文本信息
     *
     * @param state 消息状态
     * @return 对应的文本描述
     */
    public static String mapMsgState(@MsgState int state) {
        String des = CommonTool.getString(R.string.im_uikit_im_default_status);//STATE_SENDING_DES;
        switch (state) {
            case STATE_SEND_FAILED:
                des = CommonTool.getString(R.string.im_uikit_im_send_fail);//STATE_SEND_FAILD_DES;
                break;
            case STATE_SEND_SUCCESS:
                des = CommonTool.getString(R.string.im_uikit_im_send_success);//STATE_SEND_SUCCESS_DES;
                break;
            case STATE_ARRIVE:
                des = CommonTool.getString(R.string.im_uikit_im_status_arrive);//STATE_ARRIVE_DES;
                break;
            case STATE_READED:
                des = CommonTool.getString(R.string.im_uikit_im_status_readed);//STATE_READED_DES;
                break;
            case STATE_DESTROY:
                des = CommonTool.getString(R.string.im_uikit_im_status_destroy);//STATE_DESTROY_DES;
                break;
            case STATE_DEFAULT:
                des = CommonTool.getString(R.string.im_uikit_im_default_status);//STATE_DEFAULT_DES;
                break;
            case STATE_SENDING:
                des = CommonTool.getString(R.string.im_uikit_im_sending);//STATE_SENDING_DES
                break;
            case STATE_DESTROYING:
                break;
            default:
                break;

        }
        return des;
    }

    @Retention(RetentionPolicy.SOURCE)
    @IntDef(value = {STATE_SEND_FAILED, STATE_SEND_SUCCESS,
            STATE_ARRIVE, STATE_READED, STATE_DESTROY, STATE_DEFAULT,
            STATE_SENDING, STATE_DESTROYING, STATE_RECALL_SUCCESS})
    public @interface MsgState {
    }

    /**
     * 默认状态
     */
    public static final int STATE_DEFAULT = -1;
    /**
     * 消息发送失败
     */
    public static final int STATE_SEND_FAILED = 0;
    /**
     * 消息发送中
     */
    public static final int STATE_SENDING = 1;
    /**
     * 已发送
     */
    public static final int STATE_SEND_SUCCESS = 2;
    /**
     * 已送达
     */
    public static final int STATE_ARRIVE = 3;
    /**
     * 已阅读
     */
    public static final int STATE_READED = 4;
    /**
     * 已销毁
     */
    public static final int STATE_DESTROY = 5;

    /**
     * 销毁中
     */
    public static final int STATE_DESTROYING = 6;

    /**
     * 已撤回
     */
    public static final int STATE_RECALL_SUCCESS = 7;

    //***************************************************************
    //                      消息提醒方式定义
    //***************************************************************
    @Retention(RetentionPolicy.SOURCE)
    @IntDef(value = {REMIND_ALL, REMIND_NONE, REMIND_VIBRATE, REMIND_VOICE})
    public @interface RemindType {
    }

    /**
     * 不提醒
     */
    public static final int REMIND_NONE = 0;
    /**
     * 声音提醒
     */
    public static final int REMIND_VOICE = 1;
    /**
     * 震动提醒
     */
    public static final int REMIND_VIBRATE = 2;
    /**
     * 声音和震动提醒
     */
    public static final int REMIND_ALL = 3;


    //***************************************************************
    //                      消息类型定义
    //***************************************************************
    @Retention(RetentionPolicy.SOURCE)
    @IntDef(value = {MSG_TYPE_DEFAULT, MSG_TYPE_TEXT, MSG_TYPE_VOICE, MSG_TYPE_VIDEO,
            MSG_TYPE_PHOTO, MSG_TYPE_FILE, MSG_TYPE_PRESENTATION, MSG_TYPE_CUSTOM})
    public @interface MsgType {
    }

    /**
     * 默认消息类型
     */
    public static final int MSG_TYPE_DEFAULT = -1;
    /**
     * 文本新消息
     */
    public static final int MSG_TYPE_TEXT = 0;

    /**
     * 语音消息
     */
    public static final int MSG_TYPE_VOICE = 1;

    /**
     * 视频消息
     */
    public static final int MSG_TYPE_VIDEO = 2;

    /**
     * 图片消息
     */
    public static final int MSG_TYPE_PHOTO = 3;

    /**
     * 文件消息
     */
    public static final int MSG_TYPE_FILE = 4;
    /**
     * 图文消息
     */
    public static final int MSG_TYPE_WEB = 5;
    /**
     * 位置消息
     */
    public static final int MSG_TYPE_LOCATION = 6;
    /**
     * 提示信息
     */
    public static final int MSG_TYPE_PRESENTATION = 101;
    /**
     * 自定义类型消息
     */
    public static final int MSG_TYPE_CUSTOM = 102;


    //***************************************************************
    //                      会话类型定义
    //***************************************************************
    @Retention(RetentionPolicy.SOURCE)
    @IntDef(value = {CHAT_TYPE_DEFAULT, CHAT_TYPE_P2P, CHAT_TYPE_P2G, CHAT_TYPE_CUSTOM})
    public @interface ChatType {
    }

    /**
     * 默认会话类型
     */
    public static final int CHAT_TYPE_DEFAULT = 0;

    /**
     * 单人聊天
     */
    public static final int CHAT_TYPE_P2P = 1;
    /**
     * 群组聊天
     */
    public static final int CHAT_TYPE_P2G = 2;

    /**
     * 自定义消息
     */
    public static final int CHAT_TYPE_CUSTOM = 999;


    //***************************************************************
    //                      文件类型定义
    //***************************************************************
    @Retention(RetentionPolicy.SOURCE)
    @IntDef(value = {FILE_TYPE_VOICE, FILE_TYPE_VIDEO, FILE_TYPE_PHOTO, FILE_TYPE_APK,
            FILE_TYPE_TXT, FILE_TYPE_WORD, FILE_TYPE_PPT, FILE_TYPE_EXCEL, FILE_TYPE_PDF,
            FILE_TYPE_ZIP, FILE_TYPE_NORMAL})
    public @interface FileType {
    }

    /**
     * 音频文件
     */
    public static final int FILE_TYPE_VOICE = 1;
    /**
     * 视频文件
     */
    public static final int FILE_TYPE_VIDEO = 2;
    /**
     * 图片文件
     */
    public static final int FILE_TYPE_PHOTO = 3;
    /**
     * APK安装包
     */
    public static final int FILE_TYPE_APK = 4;
    /**
     * txt文本
     */
    public static final int FILE_TYPE_TXT = 5;
    /**
     * WORD文件
     */
    public static final int FILE_TYPE_WORD = 6;
    /**
     * PPT文件
     */
    public static final int FILE_TYPE_PPT = 7;
    /**
     * excel文件
     */
    public static final int FILE_TYPE_EXCEL = 8;
    /**
     * PDF文件
     */
    public static final int FILE_TYPE_PDF = 9;
    /**
     * 压缩文件
     */
    public static final int FILE_TYPE_ZIP = 10;
    /**
     * 其他类型
     */
    public static final int FILE_TYPE_NORMAL = 11;

    //***************************************************************
    //                      文件传输状态定义
    //***************************************************************
    @Retention(RetentionPolicy.SOURCE)
    @IntDef(value = {INACTIVE, DONE, LOADING, PAUSE, FAIL})
    public @interface FileState {

    }

    /**
     * 未开始
     */
    public static final int INACTIVE = 1;
    /**
     * 完成
     */
    public static final int DONE = 2;
    /**
     * 进行中
     */
    public static final int LOADING = 3;
    /**
     * 暂停
     */
    public static final int PAUSE = 4;
    /**
     * 失败
     */
    public static final int FAIL = 5;

    //***************************************************************
    //                      漫游状态定义
    //***************************************************************
    @Retention(RetentionPolicy.SOURCE)
    @IntDef(value = {ROAM_STATE_OPEN, ROAM_STATE_CLOSE})
    public @interface RoamState {
    }

    /**
     * 漫游开启
     */
    public static final int ROAM_STATE_OPEN = 1;
    /**
     * 漫游关闭
     */
    public static final int ROAM_STATE_CLOSE = 2;

    //***************************************************************
    //                      回调结果处理状态定义
    //***************************************************************
    @Retention(RetentionPolicy.SOURCE)
    @IntDef(value = {CALLBACK_NOT_HANDLED, CALLBACK_HANDLED})
    public @interface CallBackHandleState {
    }

    /**
     * 回调函数未处理
     */
    public static final int CALLBACK_NOT_HANDLED = 0;
    /**
     * 回调函数已经处理
     */
    public static final int CALLBACK_HANDLED = 1;

    //***************************************************************
    //                      控件可见状态定义
    //***************************************************************
    @IntDef({VISIBLE, INVISIBLE, GONE})
    @Retention(RetentionPolicy.SOURCE)
    public @interface Visibility {
    }

    /**
     * 控件可见
     */
    public static final int VISIBLE = View.VISIBLE;
    /**
     * 控件不可见
     */
    public static final int INVISIBLE = View.INVISIBLE;
    /**
     * 控件隐藏
     */
    public static final int GONE = View.GONE;

    //***************************************************************
    //                      消息撤回状态定义
    //***************************************************************
    @Retention(RetentionPolicy.SOURCE)
    @IntDef(value = {RECALL, CANCEL_RECALL})
    public @interface RecallAction {
    }

    /**
     * 确认撤回
     */
    public static final int RECALL = 0;

    /**
     * 取消撤回
     */
    public static final int CANCEL_RECALL = 1;

    //***************************************************************
    //                      图片类型定义
    //***************************************************************
    @Retention(RetentionPolicy.SOURCE)
    @IntDef(value = {FILE_IS_THUMB, FILE_IS_THUMB_HD, FILE_IS_RAW})
    public @interface PhotoTYpe {
    }

    /**
     * 文件是缩略图
     */
    public static final int FILE_IS_THUMB = 1;
    /**
     * 文件是高清缩略图
     */
    public static final int FILE_IS_THUMB_HD = 2;

    /**
     * 文件是原文件(仅限图片,短视频使用)
     */
    public static final int FILE_IS_RAW = 3;


    // Push state extra
    public static final String IM_PUSH_STATE = "im.action.state";
    public static final String PUSH_CODE = "pushcode";               //Push的连接状态广播key
    public static final String PUSH_CONNECTED = "10000";             //Push的长连接成功
    public static final String PUSH_DISCONNECTED = "10001";          //Push长链接断开
    public static final String PUSH_NET_OK = "10002";                //Push上报网络可用
    public static final String PUSH_NET_DISMISS = "10003";           //Push闪避无可用网络
    public static final String PUSH_CONNECT_FAIL = "10004";          //Push建立长连接失败
}
