package com.xdja.im.core.model.event;

import com.xdja.im.lib.file.bean.FileItem;

/**
 * @Package: com.xdja.im.core.model.event
 * @Author: xdjaxa
 * @Creation: 2017-04-17 11:04
 * @Version V1.0
 * @Description:OttO事件定义
 */
public class IMProxyEvent {

    /**
     * SDK初始化完成事件
     */
    public static class OnInitFinishedEvent {
        @Override
        public String toString() {
            return "OnInitFinishedEvent";
        }
    }

    public static class OnInitFailedEvent {
        @Override
        public String toString() {
            return "OnInitFailedEvent";
        }
    }

    /**
     * 已选文件事件
     */
    public static class FileSelectedEvent {
        FileItem fileInfo;

        public FileSelectedEvent(FileItem fileInfo) {
            this.fileInfo = fileInfo;
        }

        public FileItem getFileInfo() {
            return fileInfo;
        }

        public void setFileInfo(FileItem fileInfo) {
            this.fileInfo = fileInfo;
        }
    }
}
