package com.xdja.im.core.model.param;

/**
 * @Package: com.xdja.im.core.model.param
 * @Author: xdjaxa
 * @Creation: 2017-05-22 17:41
 * @Version V1.0
 * @Description:会话设置相关参数
 */
public class SessionParam {

    /**
     * 会话标记
     */
    private String sessionFlag;
    /**
     * 会话是否置顶
     */
    private boolean isTop;
    /**
     * 是否开启免打扰模式
     */
    private boolean isDisturb;
    /**
     * 听筒模式
     */
    private boolean isReceiveMode;
    /**
     * 草稿内容
     */
    private String draftContent;
    /**
     * 草稿创建时间
     */
    private long draftTime;

    public SessionParam() {
    }

    public String getSessionFlag() {
        return sessionFlag;
    }

    public void setSessionFlag(String sessionFlag) {
        this.sessionFlag = sessionFlag;
    }

    public boolean isTop() {
        return isTop;
    }

    public void setTop(boolean top) {
        isTop = top;
    }

    public boolean isDisturb() {
        return isDisturb;
    }

    public void setDisturb(boolean disturb) {
        isDisturb = disturb;
    }

    public boolean isReceiveMode() {
        return isReceiveMode;
    }

    public void setReceiveMode(boolean receiveMode) {
        isReceiveMode = receiveMode;
    }

    public String getDraftContent() {
        return draftContent;
    }

    public void setDraftContent(String draftContent) {
        this.draftContent = draftContent;
    }

    public long getDraftTime() {
        return draftTime;
    }

    public void setDraftTime(long draftTime) {
        this.draftTime = draftTime;
    }

    @Override
    public String toString() {
        return "SessionParam{" +
                "sessionFlag='" + sessionFlag + '\'' +
                ", isTop=" + isTop +
                ", isDisturb=" + isDisturb +
                ", isReceiveMode=" + isReceiveMode +
                ", draftContent='" + draftContent + '\'' +
                ", draftTime=" + draftTime +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        SessionParam param = (SessionParam) o;

        return sessionFlag != null ? sessionFlag.equals(param.sessionFlag) : param.sessionFlag == null;

    }

    @Override
    public int hashCode() {
        return sessionFlag != null ? sessionFlag.hashCode() : 0;
    }
}
