package com.xdja.im.core.proxy;

import com.xdja.im.core.callback.AccountCallback;
import com.xdja.im.core.callback.NotificationCallback;
import com.xdja.im.core.callback.UnReadMessageCallback;
import com.xdja.im.core.model.account.AccountAction;
import com.xdja.im.core.model.account.AccountBean;
import com.xdja.im.core.model.message.TalkSessionBean;

import rx.Subscriber;

/**
 * @Package: com.xdja.im.core.proxy
 * @Author: xdjaxa
 * @Creation: 2017-06-26 8:48
 * @Version V1.0
 * @Description:Ui Kit对外提供的接口
 */
public interface IMUiKitProxy {

    /**
     * 获取联系人账号接口
     *
     * @param callback
     */
    void setAccountCallback(AccountCallback callback);

    /**
     * 通知栏消息回调
     *
     * @param callback
     */
    void setNotificationCallback(NotificationCallback callback);

    /**
     * 未读消息数回调
     *
     * @param callback
     */
    void setUnReadMessageCallback(UnReadMessageCallback callback);

    /**
     * 根据联系人账号，获取联系信息
     *
     * @param account 联系人账号
     * @param type    联系人类型
     * @return 联系人信息
     */
    void getAccount(String account, int type, Subscriber<AccountBean> subscriber);

    /**
     * 联系人状态变化通知事件
     *
     * @param account 联系人账号
     * @param action  {@link AccountAction}
     */
    void notifyAccountChanged(String account, AccountAction action);

    /**
     * 通知信息
     *
     * @param sessionBean
     * @param newMsgCnt
     * @param isDisturb
     * @return
     */
    boolean notify(TalkSessionBean sessionBean, int newMsgCnt, boolean isDisturb);

    /**
     * 更新未读消息数
     *
     * @param count 未读消息数
     */
    void updateUnReadMessageCount(int count);
}
