package com.xdja.im.core.repository.impl;

import com.xdja.im.common.cache.interf.UserCache;
import com.xdja.im.core.repository.interf.SecurityRepository;

import java.util.HashMap;
import java.util.Map;

import javax.inject.Inject;

/**
 * @Package: com.xdja.im.core.repository.impl
 * @Author: xdjaxa
 * @Creation: 2017-04-11 11:10
 * @Version V1.0
 * @Description:加解密模块实现
 */
public class SecurityImpl implements SecurityRepository {

    public static final String SECURITY_CODE = "security_code";
    public static final String SECURITY_RESULT = "security_result";
    /**
     * 加解密成功
     */
    public static final int SECURITY_SUCCESS = 0;

    /**
     * 加解密失败
     */
    public static final int SECURITY_FAIL = 1;

    /**
     * 没有加解密，原始文本返回，文本为明文，文件无.dat后缀
     */
    public static final int NO_DECRYPT = 2;


    /**
     * 用户信息缓存实体
     */
    private UserCache userCache;

    /**
     * 加密失败的缓存(groupId, fail time)
     */
    private static Map<String, Long> failCache = new HashMap<>();

    /**
     * SGroup缓存(groupId, boolean)
     */
    private static Map<String, Boolean> sGCache = new HashMap<>();

    @Inject
    public SecurityImpl(UserCache userCache) {
        this.userCache = userCache;
    }

    @Override
    public Map<String, Object> encryptText(String source, String to, boolean isGroup) {
        return null;
    }

    @Override
    public Map<String, Object> encryptAsync(String source, String dest, String to, boolean isGroup) {
        return null;
    }

    @Override
    public Map<String, Object> decryptText(String source, long msgId, String from, String to, boolean isGroup) {
        return null;
    }

    @Override
    public Map<String, Object> decryptAsync(String source, String dest, String to, boolean isGroup) {
        return null;
    }
}
