package com.xdja.im.core.repository.impl.datasource;

import android.content.Context;
import android.text.TextUtils;

import com.xdja.im.base.di.DiConfig;
import com.xdja.im.base.di.scope.Scoped;
import com.xdja.im.common.cache.interf.ConfigCache;
import com.xdja.im.common.cache.interf.UserCache;
import com.xdja.im.common.network.ApiFactoryMe;
import com.xdja.im.common.network.body.ReportBody;
import com.xdja.im.core.repository.interf.datasource.CloudDataStore;
import com.xdja.im.uikit.utils.log.LogUtil;

import javax.inject.Inject;

import rx.Subscriber;
import rx.android.schedulers.AndroidSchedulers;
import rx.functions.Func1;
import rx.schedulers.Schedulers;

/**
 * @Package: com.xdja.im.core.repository.impl.datasource
 * @Author: xdjaxa
 * @Creation: 2017-04-11 13:59
 * @Version V1.0
 * @Description:
 */
public class CloudDataStoreImpl implements CloudDataStore {

    private Context context;

    private ApiFactoryMe apiFactory;

    private UserCache userCache;

    private ConfigCache configCache;

    @Inject
    public CloudDataStoreImpl(@Scoped(value = DiConfig.CONTEXT_SCOPE_APP) Context context,
                              ApiFactoryMe apiFactory,
                              UserCache userCache,
                              ConfigCache configCache) {
        this.context = context;
        this.apiFactory = apiFactory;
        this.userCache = userCache;
        this.configCache = configCache;
    }

    @Override
    public void reportPushClientId(String appId, Subscriber<Boolean> subscriber) {

        String account = userCache.get().getAccount();
        String clientId = userCache.get().getClientId();
        int type = configCache.getDevice().getDeviceType();
        if (TextUtils.isEmpty(account) || TextUtils.isEmpty(clientId)) {
            LogUtil.e("Report push clientId error.");
            return;
        }

        ReportBody body = new ReportBody(
                account,
                type,
                clientId,
                appId
        );
        LogUtil.d("ReportBody:" + body.toString());
        apiFactory.getUserSettingApi().loginReport(body)
                .subscribeOn(Schedulers.newThread())
                .map(new Func1<Object, Boolean>() {
                    @Override
                    public Boolean call(Object response) {
                        return true;
                    }
                })
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(subscriber);
    }
}
