package com.xdja.im.lib.action.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.xdja.im.lib.action.bean.OptionBean;
import com.xdja.im.uikit.R;

/**
 * @Package: com.xdja.im.lib.action.adapter
 * @Author: xdjaxa
 * @Creation: 2017-07-06 11:39
 * @Version V1.0
 * @Description:
 */
public class ChatActionViewHolder extends RecyclerView.ViewHolder{

    private View mItemView;

    private Context mContext;
    private ImageView iconImg;
    private TextView menuNameTv;

    public ChatActionViewHolder(Context context, View itemView) {
        super(itemView);
        mItemView = itemView;
        mContext = context;
        iconImg = (ImageView) itemView.findViewById(R.id.img_chat_menu);
        menuNameTv = (TextView) itemView.findViewById(R.id.tv_chat_menu);
    }

    public View getItemView() {
        return mItemView;
    }

    public void bindData(OptionBean optionBean){
        iconImg.setImageResource(getImgRes(optionBean.getIcon()));
        menuNameTv.setText(getMenuName(optionBean.getLabel()));
    }

    /**
     * 获取图标资源ID
     *
     * @param resOps
     * @return
     */
    public int getImgRes(String resOps) {
        if (TextUtils.isEmpty(resOps)) {
            return -1;
        }
        String type = resOps.substring(resOps.indexOf(".") + 1,
                resOps.lastIndexOf("."));
        String name = resOps.substring(resOps.lastIndexOf(".") + 1);
        switch (type) {
            case "drawable":
                return mContext.getResources().getIdentifier(name, "drawable", mContext.getPackageName());
            case "mipmap":
                return mContext.getResources().getIdentifier(name, "mipmap", mContext.getPackageName());
        }
        return -1;
    }

    /**
     * 获取字符串资源ID
     *
     * @param resOps
     * @return
     */
    public int getMenuName(String resOps) {
        String name = resOps.substring(resOps.lastIndexOf(".") + 1);
        return mContext.getResources().getIdentifier(name, "string", mContext.getPackageName());
    }
}
