package com.xdja.im.lib.album.ui.adapter;

import android.app.Activity;
import android.support.v4.view.PagerAdapter;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;

import com.xdja.im.common.imageloader.CustomImageLoader;
import com.xdja.im.lib.album.bean.ImageItem;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.view.PhotoView;

import java.util.ArrayList;
import java.util.List;


/**
 * @Package: com.xdja.im.lib.album.ui.adapter
 * @Author: xdjaxa
 * @Creation: 2017-04-25 17:51
 * @Version V1.0
 * @Description:
 */
public class ImagePreviewAdapter extends PagerAdapter {

    private Activity mActivity;
    private List<ImageItem> images = new ArrayList<>();

    private int screenWidth;
    private int screenHeight;

    public ImagePreviewAdapter(Activity mActivity, List<ImageItem> images) {
        this.mActivity = mActivity;
        this.images = images;

        DisplayMetrics displaysMetrics = new DisplayMetrics();
        mActivity.getWindowManager().getDefaultDisplay().getMetrics(displaysMetrics);
        screenWidth = displaysMetrics.widthPixels;
        screenHeight = displaysMetrics.heightPixels;
    }

    public void setData(ArrayList<ImageItem> images) {
        this.images = images;
    }

    @Override
    public int getCount() {
        return images == null ? 0 : images.size();
    }

    @Override
    public boolean isViewFromObject(View view, Object object) {
        return view == object;
    }

    @Override
    public Object instantiateItem(ViewGroup container, int position) {

        PhotoView photoView = new PhotoView(mActivity);
        photoView.enable();

        ImageItem imageItem = images.get(position);
       /* ImagePickerManager.getInstance().getImageLoader().loadImage(mActivity,
                photoView,
                imageItem.getPath(),
                ImageView.ScaleType.FIT_CENTER,
                screenWidth,
                screenHeight);*/
        try {
            CustomImageLoader.getInstance().crateBuilder()
                    .load(imageItem.getPath())
                    .preLoad(screenWidth, screenHeight)
                    .error(R.mipmap.im_uikit_pic_default)
                    .into(photoView)
                    .build();
        } catch (Exception e) {
            photoView.setImageResource(R.mipmap.im_uikit_pic_default);
        } catch (OutOfMemoryError e) {
            photoView.setImageResource(R.mipmap.im_uikit_pic_default);
        }

        container.addView(photoView);
        return photoView;
    }

    @Override
    public void destroyItem(ViewGroup container, int position, Object object) {
        container.removeView((View) object);
    }
}
