package com.xdja.im.lib.emoji.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.style.ImageSpan;

import com.xdja.im.lib.emoji.EmotionConfig;
import com.xdja.im.uikit.utils.ImageCache;
import com.xdja.im.uikit.utils.image.BitmapUtils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @Package: com.xdja.im.lib.emoji.utils
 * @Author: xdjaxa
 * @Creation: 2017-04-25 21:26
 * @Version V1.0
 * @Description:图文混排工具类
 */
public class EmotionUtils {

    private static Pattern pattern = Pattern.compile("(\\[emoji_[0-9]{3}\\])");

    /**
     * 表情消息获取对应的表情
     *
     * @param sourceContent
     * @param context
     * @param smallScall
     * @return
     */
    public static SpannableString formatSpanContent(CharSequence sourceContent,
                                                    Context context,
                                                    float smallScall) {
        SpannableString spannableString = new SpannableString("");
        try {
            spannableString = new SpannableString(sourceContent);
            String emoStr;
            Matcher matcher = pattern.matcher(sourceContent);
            while (matcher.find()) {
                emoStr = matcher.group(1);
                emoStr = emoStr.substring(1, emoStr.length() - 1);
                ImageCache imageCache = ImageCache.getInstance();
                Bitmap bitmap = null;
                if (smallScall == EmotionConfig.FACE_ITEM_SMALL_VALUE) {
                    if (imageCache.smallCashGet(emoStr) != null) {
                        bitmap = imageCache.smallCashGet(emoStr);
                    } else {
                        bitmap = BitmapUtils.getBitmapWithName(EmotionConfig.ASSERT_EMOTION + emoStr + ".png",
                                context.getResources());
                        bitmap = BitmapUtils.small(bitmap, smallScall);
                        imageCache.smallCashPut(emoStr, bitmap);
                    }

                } else if (smallScall == EmotionConfig.FACE_ITEM_NORMAL_VALUE) {
                    if (imageCache.get(emoStr) != null) {
                        bitmap = imageCache.get(emoStr);
                    } else {
                        bitmap = BitmapUtils.getBitmapWithName(EmotionConfig.ASSERT_EMOTION + emoStr + ".png",
                                context.getResources());
                        bitmap = BitmapUtils.small(bitmap, smallScall);
                        imageCache.put(emoStr, bitmap);
                    }
                }

                // 缩小表情图片
                // 用ImageSpan指定图片替代文字
                ImageSpan span = new ImageSpan(context, bitmap);
                // 其实写入EditView中的是这个字段“[fac”，表情图片会替代这个字段显示
                spannableString.setSpan(span, matcher.start(), matcher.end(),
                        Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return spannableString;
    }

    /**
     * 根据Index获取表情资源名称
     *
     * @param facesPos
     * @return
     */
    public static SpannableString formatSpanByIndex(Context context, int facesPos, float smallScall) {
        String srcName = "emoji_" + String.format("%03d", facesPos) + ".png";
        try {
            Bitmap bitmap = BitmapUtils.getBitmapWithName(
                    EmotionConfig.ASSERT_EMOTION + srcName, context.getResources());
            bitmap = BitmapUtils.small(bitmap, smallScall);
            ImageSpan is = new ImageSpan(context, bitmap);
            CharSequence cs = "[emoji_" + String.format("%03d", facesPos) + "]";
            SpannableString ss = new SpannableString(cs);
            ss.setSpan(is, 0, cs.length(), SpannableString.SPAN_EXCLUSIVE_EXCLUSIVE);
            return ss;
        } catch (NoSuchFieldException e) {
            e.printStackTrace();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return new SpannableString("[" + srcName + "]");
    }

    /**
     * 表情内容匹配
     *
     * @param content
     * @return
     */
    public static boolean mathEmotion(String content) {
        Matcher matcher = pattern.matcher(content);
        return matcher.find();
    }
}
