package com.xdja.im.lib.video.ui.view;

import android.annotation.SuppressLint;
import android.os.Handler;
import android.os.Message;
import android.view.MotionEvent;
import android.view.SurfaceView;
import android.view.View;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.xdja.im.base.frame.view.ActivitySuperBaseView;
import com.xdja.im.common.utils.CommonTool;
import com.xdja.im.lib.video.VideoRecorderConfig;
import com.xdja.im.lib.video.bean.VideoItem;
import com.xdja.im.lib.video.manager.ErrorCode;
import com.xdja.im.lib.video.manager.VideoManager;
import com.xdja.im.lib.video.ui.presenter.VideoRecorderPresenter;
import com.xdja.im.lib.video.ui.view.vu.VideoRecorderVu;
import com.xdja.im.lib.video.utils.DisplayUtils;
import com.xdja.im.lib.video.utils.UnitUtil;
import com.xdja.im.lib.video.widget.CustomView;
import com.xdja.im.lib.video.widget.SendView;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.im.lib.video.widget.FocusView;

/**
 * @Package: com.xdja.im.lib.video.ui
 * @Author: xdjaxa
 * @Creation: 2017-04-24 9:15
 * @Version V1.0
 * @Description:
 */
public class ViewVideoRecorder extends ActivitySuperBaseView<VideoRecorderPresenter>
        implements VideoRecorderVu, VideoManager.IVideoRecordCallback, View.OnClickListener,
        View.OnTouchListener {

    private VideoManager mVideoManager;
    private CustomView progressBar;
    private int mProgress;
    private TextView videoRecordTime;
    private TextView mBtnRecord;
    private SendView send;
    private RelativeLayout recordLayout;
    private RelativeLayout toolBars;
    private boolean isCompleteRecord;
    private boolean isSending;
    private Handler handler;

    private SurfaceView mSurfaceView;
	private FocusView mFocusView;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_activity_video_receoder;
    }

    @Override
    protected void injectView() {
        super.injectView();
        View view = getView();
        if (view != null) {
            initView(view);
        }
    }

    /**
     * 初始化界面控件
     */
    private void initView(View view) {
        handler = new ViewRecordHandler();
        mSurfaceView = (SurfaceView) view.findViewById(R.id.main_surface_view);
        toolBars = (RelativeLayout) view.findViewById(R.id.layout_video_tools);
        TextView bottomBarBack = (TextView) view.findViewById(R.id.bottombar_back_recorder);

        send = (SendView) view.findViewById(R.id.view_send);
        send.backLayout.setOnClickListener(this);
        send.selectLayout.setOnClickListener(this);

        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams) bottomBarBack.getLayoutParams();
        params.height = DisplayUtils.getBottomStatusHeight(getActivity());
        bottomBarBack.setLayoutParams(params);

        mBtnRecord = (TextView) view.findViewById(R.id.btn_recorder);
        mBtnRecord.setOnTouchListener(this);
        TextView btnTransCamera = (TextView) view.findViewById(R.id.btn_trans);
        btnTransCamera.setOnClickListener(this);

        videoRecordTime = (TextView) view.findViewById(R.id.video_record_time);
        TextView btnClose = (TextView) view.findViewById(R.id.btn_close);
        btnClose.setOnClickListener(this);

        recordLayout = (RelativeLayout) view.findViewById(R.id.layout_recorder);
        progressBar = (CustomView) view.findViewById(R.id.main_progress_bar);

        mVideoManager = new VideoManager(getActivity());
		mFocusView = (FocusView) view.findViewById(R.id.video_focusview);
    }

    @Override
    public void startPreview() {
        mSurfaceView.setVisibility(View.VISIBLE);
        mVideoManager.setRecordCallback(this);
        mVideoManager.setSurfaceView(mSurfaceView);
    }

    private void startView() {
        if (progressBar.getVisibility() == View.GONE) {
            videoRecordTime.setVisibility(View.VISIBLE);
            toolBars.setVisibility(View.GONE);
            videoRecordTime.setVisibility(View.VISIBLE);
            videoRecordTime.setText("");
            progressBar.startAnim();
            mProgress = 0;
            progressBar.setVisibility(View.VISIBLE);
            progressBar.startProgressBar();
        }
    }

    private void stopView(boolean isSave) {
        if (progressBar.getVisibility() == View.VISIBLE) {
            progressBar.stopAnim();
            handler.removeMessages(0);
            progressBar.stopProgressBar();
            progressBar.setVisibility(View.GONE);
            videoRecordTime.setVisibility(View.GONE);

            if (isSave) {
                mBtnRecord.setVisibility(View.GONE);
                send.startAnim(getContext());
            } else {
                toolBars.setVisibility(View.VISIBLE);
            }
        }
    }

    @Override
    public void prepareRecord() {
        handler.removeMessages(0);
        handler.sendMessageDelayed(handler.obtainMessage(0), 1000);
        isCompleteRecord = false;
    }

    @Override
    public void completeRecord() {
        isCompleteRecord = true;
    }

    /**
     * 相机准备失败
     *
     * @param code
     * @param msg
     */
    @Override
    public void onPrepareFailed(int code, String msg) {
        LogUtil.e("ERROR: Recorder video failed. code " + code + ", msg " + msg);
        if (code == ErrorCode.PARAM_CAMERA_FAILED) {
            CommonTool.showToast(R.string.im_uikit_carame_error);
            getActivity().finish();
        } else {
            CommonTool.showToast(R.string.im_uikit_video_recorder_failed);
            cancelAndRerecord();
        }
    }

    @Override
    public void onClick(View v) {
        int id = v.getId();
        if (id == R.id.btn_rerecored) {//重新录制
            cancelAndRerecord();

        } else if (id == R.id.btn_send) {
            isSending = true;
            mVideoManager.stopPlay(false);

            VideoItem videoItem = new VideoItem();
            //缩略图
            videoItem.setFilePath(mVideoManager.getFirstFrameFile().getPath());
            videoItem.setFileName(mVideoManager.getFirstFrameFile().getName());
            videoItem.setFileSize(mVideoManager.getFirstFrameFile().length());
            videoItem.setSuffix(UnitUtil.getFileSuffix(
                    mVideoManager.getFirstFrameFile().getPath()));

            //视频源文件
            videoItem.setRawFileName(mVideoManager.getVideoFile().getName());
            videoItem.setRawFilePath(mVideoManager.getVideoFile().getPath());
            videoItem.setRawFileSize(mVideoManager.getVideoFile().length());
            videoItem.setRawSuffix(".mp4");
            //视频录制时长
            videoItem.setDuration(mProgress);
            getPresenter().sendVideoMessage(videoItem);

        } else if (id == R.id.btn_close) {
            getActivity().finish();
        } else if (id == R.id.btn_trans) {
            mVideoManager.transformCamera();
        }
    }

    public void cancelAndRerecord() {
        send.stopAnim(getContext());
        stopView(false);
        isCompleteRecord = false;
        recordLayout.setVisibility(View.VISIBLE);
        toolBars.setVisibility(View.VISIBLE);
        mBtnRecord.setVisibility(View.VISIBLE);
        videoRecordTime.setVisibility(View.GONE);
        mFocusView.setVisibility(View.VISIBLE);
        mVideoManager.deleteTargetFile();
        //停止预览并且重新录制视频
        mVideoManager.stopPlay(true);
    }

    @Override
    public int onKeyBack() {
        if (isCompleteRecord) {
            cancelAndRerecord();
            return 1;
        }
        return 0;
    }


    @SuppressLint("ClickableViewAccessibility")
    @Override
    public boolean onTouch(View v, MotionEvent event) {
        boolean ret = false;
        int action = event.getAction();

        if (v.getId() == R.id.btn_recorder) {
            switch (action) {
                case MotionEvent.ACTION_DOWN:
                    startView();
                    mVideoManager.record();
                    ret = true;
                    break;
                case MotionEvent.ACTION_UP:
                    if (mVideoManager.isRecording() &&
                            mProgress < VideoRecorderConfig.MIN_RECORDER_DURATION) {
                        //时间太短不保存
                        mVideoManager.stopRecordUnSave();
                        showToast(R.string.im_uikit_video_record_timeshort);
                        stopView(false);
                        break;
                    }
                    //停止录制
                    mVideoManager.stopRecordSave();
                    stopView(true);
                    ret = false;
                    mFocusView.setVisibility(View.GONE);
                    break;
            }

        }
        return ret;
    }


    @SuppressLint("HandlerLeak")
    private class ViewRecordHandler extends Handler {
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0:
                    if (mVideoManager.isRecording()) {
                        mProgress++;
                        videoRecordTime.setText(UnitUtil.getVideoRecordDuration(mProgress, getContext()));

                        if (mProgress > VideoRecorderConfig.MAX_RECORDE_DURATION) {
                            mProgress--;
                            videoRecordTime.invalidate();
                            //停止录制
                            mVideoManager.stopRecordSave();
                            stopView(true);
                        } else {
                            sendMessageDelayed(handler.obtainMessage(0), 1000);
                        }
                    }
                    break;
            }
        }
    }

    @Override
    public boolean isCompleteRecord() {
        return isCompleteRecord;
    }

    @Override
    public VideoManager getVideoManager() {
        return mVideoManager;
    }

    @Override
    public boolean isSending() {
        return isSending;
    }
}
