package com.xdja.im.uikit;

import com.xdja.im.core.model.options.ChatOption;
import com.xdja.im.core.model.options.DisturbOption;
import com.xdja.im.core.model.options.NotificationOption;
import com.xdja.im.core.model.options.PanelOption;
import com.xdja.im.core.model.options.SessionOption;

/**
 * @Package: com.xdja.im.uikit
 * @Author: xdjaxa
 * @Creation: 2017-04-17 14:53
 * @Version V1.0
 * @Description:SDK 相关配置信息
 */
public class UiKitOptions {

    private UiKitOptions() {
    }

    private static class SingletonInstance{
        private static final UiKitOptions mInstance = new UiKitOptions();
    }

    public static UiKitOptions getOptions() {
        return SingletonInstance.mInstance;
    }

    /**
     * 缓存文件绝对路径
     */
    private String cacheDir;

    /**
     * 消息是否需要加密
     */
    private boolean bEncription;

    /**
     * 会话相关的设置信息
     */
    private SessionOption sessionOption;

    /**
     * 聊天相关设置
     */
    private ChatOption chatOption;

    /**
     * 新消息通知提醒相关配置信息
     */
    private NotificationOption notificationOption;

    /**
     * 免打扰相关配置信息
     */
    private DisturbOption disturbOption;

    /**
     * 操作面板设置信息
     */
    private PanelOption panelOption;

    public String getCacheDir() {
        return cacheDir;
    }

    public void setCacheDir(String cacheDir) {
        this.cacheDir = cacheDir;
    }

    public boolean isbEncription() {
        return bEncription;
    }

    public void setEncription(boolean bEncription) {
        this.bEncription = bEncription;
    }

    public SessionOption getSessionOption() {
        return sessionOption;
    }

    public ChatOption getChatOption() {
        return chatOption;
    }

    public NotificationOption getNotificationOption() {
        return notificationOption;
    }

    public DisturbOption getDisturbOption() {
        return disturbOption;
    }

    public PanelOption getPanelOption() {
        return panelOption;
    }
}
