package com.xdja.im.uikit.action;

import android.content.Context;

import com.xdja.im.common.router.LiteRouter;

/**
 * @Package: com.xdja.im.uikit.action
 * @Author: xdjaxa
 * @Creation: 2017-06-28 16:30
 * @Version V1.0
 * @Description:IM路由
 */
public class ImRouter {

    /**
     * 打开聊天界面
     *
     * @param context  上下文
     * @param talkId   会话ID
     * @param talkType 会话类型
     */
    public static void openChatListActivity(Context context, String talkId, int talkType) {
        LiteRouter router = new LiteRouter.Builder().build();
        IntentService intentService = router.create(IntentService.class, context);
        intentService.openChatListActivity(talkId, talkType);
    }

    /**
     * 打开设置界面
     *
     * @param context  上下文
     * @param talkId   会话ID
     * @param talkType 会话类型
     */
    public static void openSettingActivity(Context context, String talkId, int talkType) {
        LiteRouter router = new LiteRouter.Builder().build();
        IntentService intentService = router.create(IntentService.class, context);
        intentService.openSettingActivity(talkId, talkType);
    }

    /**
     * 打开车载应用APP
     *
     * @param context 上下文
     */
    public static void openCarhelperActivity(Context context) {
        LiteRouter router = new LiteRouter.Builder().build();
        IntentService intentService = router.create(IntentService.class, context);
        intentService.openCarhelperActivity();
    }

    /**
     * 打开警视语音通话界面
     *
     * @param context 上下文
     */
    public static void onpenCallWaitingActivity(Context context, String type, String talkId , int talkType) {
        LiteRouter router = new LiteRouter.Builder().build();
        IntentService intentService = router.create(IntentService.class, context);
        intentService.onpenCallWaitingActivity(type, talkId, talkType);
    }

}
