package com.xdja.im.uikit.base;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.provider.Settings;
import android.support.annotation.Nullable;
import android.support.v7.app.AlertDialog;

import com.xdja.im.base.di.component.DaggerUserComponent;
import com.xdja.im.base.di.component.RepositoryComponent;
import com.xdja.im.base.di.component.UserComponent;
import com.xdja.im.base.frame.BaseView;
import com.xdja.im.base.frame.Presenter;
import com.xdja.im.base.frame.presenter.BaseActivityPresenter;
import com.xdja.im.common.utils.CommonTool;
import com.xdja.im.uikit.ImUiKit;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.utils.log.LogUtil;

/**
 * @Package: com.xdja.im.uikit.presenter.activity
 * @Author: xdjaxa
 * @Creation: 2017-04-11 10:37
 * @Version V1.0
 * @Description:
 */
public abstract class ImBaseActivity<P extends Presenter, V extends BaseView> extends BaseActivityPresenter<P, V> {

    protected UserComponent mComponent;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        setTheme(R.style.im_uikit_ImAppTheme);
        super.onCreate(savedInstanceState);
    }

    @Override
    protected void onBindView(@Nullable Bundle savedInstanceState) {
        super.onBindView(savedInstanceState);
        RepositoryComponent repositoryComponent = ImUiKit.getInstance().getComponent();
        if (repositoryComponent != null) {
            mComponent = DaggerUserComponent.builder()
                    .repositoryComponent(repositoryComponent)
                    .build();
        }
        if (mComponent == null) {
            LogUtil.e("Fatal :User component is null .");
            finish();
        }
    }

    /**
     * 启动申请权限框
     */
    protected void showMissingPermissionDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder(this);
        builder.setTitle("提示");
        builder.setMessage("当前应用缺少必要权限。请点击\"设置\"-\"权限\"-打开所需权限。");

        // 拒绝, 退出应用
        builder.setNegativeButton("取消", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                finish();
            }
        });
        builder.setPositiveButton("设置", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                startAppSettings();
            }
        });
        builder.setCancelable(false);
        builder.show();
    }

    /**
     * 启动应用的设置
     */
    private void startAppSettings() {
        Intent intent = new Intent(
                Settings.ACTION_APPLICATION_DETAILS_SETTINGS);
        intent.setData(Uri.parse("package:" + getPackageName()));
        startActivity(intent);
    }

    protected Context getContext() {
        return this;
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
    }

    /**
     * Toast提示
     *
     * @param content
     */
    protected void showToast(String content) {
        CommonTool.showToast(content);
    }

    /**
     * Toast提示
     *
     * @param resId
     */
    protected void showToast(int resId) {
        CommonTool.showToast(resId);
    }
}
