package com.xdja.im.uikit.base;

import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.provider.Settings;
import android.support.annotation.IdRes;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v7.app.AlertDialog;

import com.xdja.im.base.di.component.DaggerUserComponent;
import com.xdja.im.base.di.component.RepositoryComponent;
import com.xdja.im.base.di.component.UserComponent;
import com.xdja.im.base.frame.Presenter;
import com.xdja.im.base.frame.presenter.BaseFragmentPresenter;
import com.xdja.im.base.frame.view.FragmentBaseView;
import com.xdja.im.common.utils.CommonTool;
import com.xdja.im.uikit.ImUiKit;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.utils.log.LogUtil;

/**
 * @Package: com.xdja.im.uikit.presenter.base
 * @Author: xdjaxa
 * @Creation: 2017-04-11 10:40
 * @Version V1.0
 * @Description:
 */
public abstract class ImBaseFragment<P extends Presenter, V extends FragmentBaseView>
        extends BaseFragmentPresenter<P, V> {

    protected UserComponent mComponent;

    @Override
    protected void onBindView(Bundle savedInstanceState) {
        super.onBindView(savedInstanceState);
        RepositoryComponent repositoryComponent = ImUiKit.getInstance().getComponent();
        if (repositoryComponent != null) {
            mComponent = DaggerUserComponent.builder()
                    .repositoryComponent(repositoryComponent)
                    .build();
        }
        if (mComponent == null) {
            LogUtil.e("Fatal :User component is null .");
            getActivity().finish();
        }
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
    }

    public void switchFragment(ImBaseFragment fragment, boolean addToBackStack) {
        switchFragment(fragment, android.R.id.content, addToBackStack);
    }

    protected void switchFragment(ImBaseFragment fragment, @IdRes int contentRes, boolean addToBackStack) {
        FragmentManager fg = getFragmentManager();
        FragmentTransaction ft = fg.beginTransaction();

        if (addToBackStack) {
            ft.setCustomAnimations(
                    R.anim.im_uikit_open_enter,
                    R.anim.im_uikit_open_exit,
                    R.anim.im_uikit_close_enter,
                    R.anim.im_uikit_close_exit);
        }

        ft.replace(contentRes, fragment, fragment.getName());
        if (addToBackStack) {
            ft.addToBackStack(fragment.getName());
        }
        ft.commit();
    }

    /**
     * 启动申请权限框
     */
    protected void showMissingPermissionDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder(getContext());
        builder.setTitle("提示");
        builder.setMessage("当前应用缺少必要权限。请点击\"设置\"-\"权限\"-打开所需权限。");

        // 拒绝, 退出应用
        builder.setNegativeButton("取消", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                getActivity().finish();
            }
        });
        builder.setPositiveButton("设置", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                startAppSettings();
            }
        });
        builder.setCancelable(false);
        builder.show();
    }

    /**
     * 启动应用的设置
     */
    private void startAppSettings() {
        Intent intent = new Intent(
                Settings.ACTION_APPLICATION_DETAILS_SETTINGS);
        intent.setData(Uri.parse("package:" + getPackageName()));
        startActivity(intent);
    }

    protected void finish() {
        getActivity().finish();
    }

    protected void showToast(String content) {
        CommonTool.showToast(content);
    }

    protected void showToast(int resId) {
        CommonTool.showToast(resId);
    }

    public String getName() {
        return this.getClass().getName();
    }

    public String getPackageName() {
        return getContext().getPackageName();
    }
}
