package com.xdja.im.uikit.ui.view;

import android.graphics.drawable.AnimationDrawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.view.BaseListDialog;

/**
 * @Package: com.xdja.im.uikit.ui
 * @Author: xdjaxa
 * @Creation: 2017-04-20 14:38
 * @Version V1.0
 * @Description:聊天栏目消息接收基类
 */
public class BaseReceiveItem extends BaseChatItem {

    /**
     * 内容布局
     */
    protected RelativeLayout mContentLayout;
    /**
     * 闪信销毁动画控件
     */
    private ImageView mBombAnimImg;

    @Override
    protected void injectView() {
        super.injectView();
        mContentLayout = (RelativeLayout) findViewById(R.id.layout_message_container);
        mBombAnimImg = (ImageView) findViewById(R.id.img_bomb_anim);

        mContentLayout.setOnLongClickListener(new View.OnLongClickListener() {
            @Override
            public boolean onLongClick(View v) {
                mPopDialog.addData(getPopItemData());
                mPopDialog.show(curPosition);
                return true;
            }
        });
        mPopDialog.setOnItemClickListener(new BaseListDialog.onItemClickListener() {
            @Override
            public void onItemClick(View view, int position, int itemPosition) {
                mPopDialog.dismiss();
                switch (position) {
                    case 0://删除消息
                        getPresenter().deleteItem(itemPosition);
                        break;
                    case 1://复制消息
                        getPresenter().copyMessage(itemPosition);
                        break;
                }
            }
        });
    }

    @Override
    public void bindDataSource(int position, @NonNull TalkMessageBean dataSource) {
        super.bindDataSource(position, dataSource);

    }

    /**
     * 设置消息显示控件背景
     *
     * @param resId 资源文件id
     */
    protected void setContentLayoutBackground(@DrawableRes int resId) {
        mContentLayout.setBackgroundResource(resId);
    }

    /**
     * 开始闪信动画
     */
    protected void startBombAnim() {
        if (mBombAnimImg != null) {
            AnimationDrawable boomAnim = (AnimationDrawable) mBombAnimImg.getBackground();
            boomAnim.stop();
            boomAnim.start();
        }
    }

    protected void setMessageDestroy(boolean isDestroy) {
        if (dataSource.getMessageType() == ConstDef.MSG_TYPE_PHOTO ||
                dataSource.getMessageType() == ConstDef.MSG_TYPE_VIDEO) {
            return;
        }
        if (mContentLayout != null) {
            if (isDestroy) {
                mContentLayout.setBackgroundResource(R.drawable.im_uikit_bg_receive_shan_selector);
            } else {
                mContentLayout.setBackgroundResource(R.drawable.im_uikit_bg_receive_selector);
            }
        }
    }


    protected void setDestroyView(TextView destroyView, boolean isDestroy, String destroyStr) {
        if (destroyView != null) {
            if (isDestroy) {
                destroyView.setVisibility(View.VISIBLE);
                destroyView.setTextColor(getLimitTextColor());
                destroyView.setText(destroyStr);
            } else {
                destroyView.setVisibility(View.GONE);
            }
        }
    }

    /**
     * 显示选择框
     */
    protected void showPopDialog() {
        mPopDialog.addData(getPopItemData());
        mPopDialog.show(curPosition);
    }

    /**
     * 隐藏选择框
     */
    protected void dismissPopDialog() {
        if (mPopDialog != null) {
            mPopDialog.dismiss();
        }
    }
}

