package com.xdja.im.uikit.ui.view;

import android.support.annotation.NonNull;
import android.text.TextUtils;

import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.TalkSessionBean;
import com.xdja.im.core.model.param.SessionParam;
import com.xdja.im.lib.emoji.EmotionConfig;
import com.xdja.im.lib.emoji.utils.EmotionUtils;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.utils.log.LogUtil;

/**
 * @Package:com.xdja.im.uikit.ui
 * @Author:Lei
 * @Creation:2017-04-13 00:48
 * @Version 1.0
 * @Description:群组会话显示控件
 */
public class ViewGroupItem extends ViewSessionItem {

    public static final String SEPARATOR = ": ";

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_item_session_group;
    }

    @Override
    public void bindDataSource(int position, @NonNull TalkSessionBean dataSource) {
        super.bindDataSource(position, dataSource);

    }

    @Override
    protected CharSequence getContent() {
        if (dataSource.getLastMsg().isMine()) {
            return getMessageContent();
        } else {
            return getUserName() + SEPARATOR + getMessageContent();
        }
    }

    /**
     * 获取消息显示内容
     *
     * @return 消息体
     */
    private CharSequence getMessageContent() {
        //草稿处理
        SessionParam param = dataSource.getParam();
        if (param != null && !TextUtils.isEmpty(param.getDraftContent()) &&
                param.getDraftTime() > 0) {
            CharSequence content = formatDraft(param.getDraftContent());
            LogUtil.d("ViewGroupItem draft:" + content);
            return EmotionUtils.formatSpanContent(content,
                    getActivity(),
                    EmotionConfig.FACE_ITEM_SMALL_VALUE);
        }
        TalkMessageBean talkMessageBean = dataSource.getLastMsg();
        if (talkMessageBean == null) {
            LogUtil.w("Last message info is null.");
            return "";
        }
        int messageType = talkMessageBean.getMessageType();
        //闪信并且已销毁
        if (!talkMessageBean.isMine() &&
                talkMessageBean.isBomb() &&
                (talkMessageBean.getMessageState() == ConstDef.STATE_DESTROY)) {
            return getStringRes(R.string.im_uikit_bomb);
        }
        //普通消息
        switch (messageType) {
            case ConstDef.MSG_TYPE_TEXT:
                return EmotionUtils.formatSpanContent(dataSource.getContent(),
                        getActivity(),
                        EmotionConfig.FACE_ITEM_SMALL_VALUE);
            case ConstDef.MSG_TYPE_VOICE:
                return getStringRes(R.string.im_uikit_voice);
            case ConstDef.MSG_TYPE_VIDEO:
                return getStringRes(R.string.im_uikit_video);
            case ConstDef.MSG_TYPE_PHOTO:
                return getStringRes(R.string.im_uikit_image);
            case ConstDef.MSG_TYPE_FILE:
                return getStringRes(R.string.im_uikit_file);
            default:
                return "" + dataSource.getContent();
        }
    }
}
