package com.xdja.im.uikit.ui.view;

import android.support.annotation.NonNull;
import android.widget.TextView;

import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.utils.log.LogUtil;

/**
 * @Package:com.xdja.im.uikit.ui
 * @Author:Lei
 * @Creation:2017-04-13 00:48
 * @Version 1.0
 * @Description: 自定义会话类型
 */
public class ViewRecvCustomItem extends BaseReceiveItem {

    private TextView mContentTv;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_item_chat_receive_custom;
    }

    @Override
    protected void injectView() {
        super.injectView();

        mContentTv = (TextView) findViewById(R.id.tv_custom_content);
    }

    @Override
    public void bindDataSource(int position, @NonNull TalkMessageBean dataSource) {
        super.bindDataSource(position, dataSource);

        if (dataSource == null) {
            LogUtil.e("ERROR: Custom data source is null.");
            return;
        }
        mContentTv.setText(dataSource.getContent());
    }
}
