package com.xdja.im.uikit.ui.view;

import android.os.Handler;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.widget.TextView;

import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.lib.emoji.utils.EmotionUtils;
import com.xdja.im.uikit.R;

/**
 * @Package: com.xdja.im.uikit.ui
 * @Author: xdjaxa
 * @Creation: 2017-04-20 14:41
 * @Version V1.0
 * @Description:
 */
public class ViewRecvTextItem extends BaseReceiveItem {

    /**
     * 消息显示文本
     */
    private TextView mContentTv;


    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_item_chat_receive_text;
    }

    @Override
    protected void injectView() {
        super.injectView();
        mContentTv = (TextView) findViewById(R.id.tv_content);
    }

    @Override
    public void bindDataSource(int position, @NonNull TalkMessageBean dataSource) {
        super.bindDataSource(position, dataSource);

        if (dataSource != null) {
            if (dataSource.getMessageState() == ConstDef.STATE_DESTROY) {
                setMessageDestroy(true);
                setRecContentTextColor(getLimitTextColor());
                setRecContentText(R.string.im_uikit_text_bomb);
            } else {
                setMessageDestroy(false);
                setRecContentTextColor(getNormalTextColor());
                if (!TextUtils.isEmpty(dataSource.getContent())) {
                    setRecContentText(EmotionUtils.formatSpanContent(dataSource.getContent(),
                            getActivity(),
                            1.1f));
                } else {
                    //setRecContentText(String.valueOf(""));
                }

                //发送阅读回执
                if (dataSource.getMessageState() < ConstDef.STATE_READED) {
                    getPresenter().sendReadReceipt(dataSource);
                }

                //开始执行销毁动画
                if (dataSource.getMessageState() == ConstDef.STATE_DESTROYING) {
                    startBombAnim();
                    final TalkMessageBean cloneObj = new TalkMessageBean(dataSource);
                    new Handler().postDelayed(new Runnable() {
                        @Override
                        public void run() {
                            getPresenter().postDestroyAnimate(cloneObj);
                        }
                    }, 700);
                }

            }
        }
    }

    private void setRecContentTextColor(int colorId) {
        if (mContentTv != null) {
            mContentTv.setTextColor(colorId);
        }
    }

    private void setRecContentText(int contentTextId) {
        if (mContentTv != null) {
            mContentTv.setText(contentTextId);
        }
    }

    private void setRecContentText(CharSequence contentText) {
        if (mContentTv != null) {
            mContentTv.setText(contentText);
        }
    }
}
