package com.xdja.im.uikit.ui.view;

import android.view.View;
import android.widget.AdapterView;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.TextView;

import com.xdja.im.base.frame.view.FragmentSuperBaseView;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.ui.adapter.SessionListAdapter;
import com.xdja.im.uikit.ui.presenter.SessionListPresenter;
import com.xdja.im.uikit.ui.view.vu.SessionListVu;
import com.xdja.im.uikit.view.BaseListDialog;

/**
 * @Package: com.xdja.im.uikit.view
 * @Author: xdjaxa
 * @Date: 2017-04-10 20:23
 * @Version V1.0
 * @Comment:
 */
public class ViewSessionList extends FragmentSuperBaseView<SessionListPresenter>
        implements SessionListVu {

    /**
     * 会话列表
     */
    private ListView mChatSessionList;
    /**
     * 加载进度控件
     */
    private ProgressBar mLoadingPBar;
    /**
     * 消息列表为空显示view
     */
    private TextView mEmptyHintTv;
    /**
     * 长按Item弹出的控件
     */
    private BaseListDialog mPopDialog;

    /**
     * Item数据
     */
    private CharSequence[] mPopItemData;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_fragment_session_list;
    }

    @Override
    protected void injectView() {
        super.injectView();
        mChatSessionList = (ListView) findViewById(R.id.rv_session_list);
        mLoadingPBar = (ProgressBar) findViewById(R.id.pbar_loading);
        mEmptyHintTv = (TextView) findViewById(R.id.tv_empty);
        mChatSessionList.setEmptyView(mEmptyHintTv);

        mPopDialog = new BaseListDialog(getContext()) {
            @Override
            public CharSequence[] getOptions() {
                return mPopItemData = getContext().getResources()
                        .getStringArray(R.array.session_options);
            }
        };
        setListener();
    }

    private void setListener() {
        mChatSessionList.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                getPresenter().onListItemClick(position);
            }
        });
        mChatSessionList.setOnItemLongClickListener(new AdapterView.OnItemLongClickListener() {
            @Override
            public boolean onItemLongClick(AdapterView<?> parent, View view, int position, long id) {
                mPopDialog.addData(getPopItemData(position));
                mPopDialog.show(position);
                return true;
            }
        });
        mPopDialog.setOnItemClickListener(new BaseListDialog.onItemClickListener() {
            @Override
            public void onItemClick(View view, int position, int itemPosition) {
                switch (position) {
                    case 0: //会话置顶
                        getPresenter().setSessionTop(itemPosition);
                        break;
                    case 1: //会话删除
                        getPresenter().deleteSession(itemPosition);
                        break;
                    case 2: //会话免打扰
                        getPresenter().setDisturb(itemPosition);
                        break;
                }
                mPopDialog.dismiss();
            }
        });
    }

    @Override
    public void setAdapter(SessionListAdapter adapter) {
        mChatSessionList.setAdapter(adapter);
        mEmptyHintTv.setVisibility(View.GONE);
    }

    @Override
    public void setProgressBarVisibility(int visibility) {
        mLoadingPBar.setVisibility(visibility);
    }

    public CharSequence[] getPopItemData(int position) {
        CharSequence[] data = new CharSequence[3];
        if (getPresenter().isSessionTop(position)) {
            data[0] = mPopItemData[1];
        } else {
            data[0] = mPopItemData[0];
        }
        data[1] = mPopItemData[2];

        if (getPresenter().isDisturb(position)) {
            data[2] = mPopItemData[4];
        } else {
            data[2] = mPopItemData[3];
        }
        return data;

    }
}
