package com.xdja.im.uikit.utils.audio;

import android.text.TextUtils;

import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.lib.audio.player.AudioPlayerManager;
import com.xdja.im.uikit.utils.log.LogUtil;

public class AudioPlayerManagerProxy {

    /**
     * 语音播放
     *
     * @param fileInfo  文件信息
     * @param messageId 消息
     * @param isNext    是否需要播放下一条语音消息
     */
    public static void startToPlay(FileInfo fileInfo, long messageId, boolean isNext) {
        preStartPlay(fileInfo, messageId);
        if (fileInfo != null) {
            getManager().startToPlay(fileInfo.getFilePath(), messageId, isNext);
        }
    }

    /**
     * 播放前需要进行的操作
     *
     * @param fileInfo 播放的文件
     */
    public static void preStartPlay(FileInfo fileInfo, long messageId) {
        if (isPlaying()) {
            stopPlay();
        }
    }

    /**
     * 判断传入的文件是否是正在播放的文件
     *
     * @param fileInfo 需要判断的文件
     * @return
     */
    public static synchronized boolean isPlayingWithMessage(FileInfo fileInfo) {
        String currentPath = getManager().getCurrentPlayPath();
        Object[] args = getManager().getArgs();
        LogUtil.d("Player isPlayingWithMessage currPath=" + (currentPath == null ? "null" : currentPath)
                + ",filPath" + fileInfo.getFilePath());
        if (args == null ||
                (args != null && args.length == 0) ||
                TextUtils.isEmpty(currentPath) ||
                fileInfo == null ||
                (fileInfo != null && TextUtils.isEmpty(fileInfo.getFilePath()))) {
            return false;
        }

        long msgId = (long) args[0];
        if (fileInfo.getFilePath().equals(currentPath)
                && fileInfo.getTalkMessageId() == msgId) {
            return true;
        }
        return false;
    }

    public static void release() {
        getManager().releasePlayer();
    }

    private static AudioPlayerManager getManager() {
        return AudioPlayerManager.getInstance();
    }

    public static void stopPlay() {
        getManager().stopPlay();
    }

    public static boolean isPlaying() {
        return getManager().isPlaying();
    }
}
