package com.xdja.im.uikit.view;

import android.app.Dialog;
import android.content.Context;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListView;
import android.widget.SimpleAdapter;

import com.xdja.im.uikit.R;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Package: com.xdja.im.uikit.view.popup
 * @Author: xdjaxa
 * @Creation: 2017-05-07 16:34
 * @Version V1.0
 * @Description: 列表Dialog
 */
public abstract class BaseListDialog extends Dialog {

    public static final String PARAM_ITEM = "item";

    private ListView mListView;

    private SimpleAdapter mAdapter;

    private List<Map<String, String>> mDatas = new ArrayList<>();

    private onItemClickListener onItemClickListener;

    private int mItemPosition;

    public void setOnItemClickListener(onItemClickListener listener) {
        this.onItemClickListener = listener;
    }

    public BaseListDialog(@NonNull Context context) {
        super(context, R.style.im_uikit_BaseDialogStyle);
        setContentView(R.layout.im_uikit_dialg_option_list);

        setCancelable(true);

        initView();
    }

    private void initView() {

        mListView = (ListView) findViewById(R.id.lv_options);

        mAdapter = new SimpleAdapter(getContext(),
                mDatas,
                R.layout.im_uikit_item_dialog_option,
                new String[]{PARAM_ITEM},
                new int[]{R.id.tv_option});
        mListView.setAdapter(mAdapter);

        mListView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                if (onItemClickListener != null) {
                    onItemClickListener.onItemClick(view, position, mItemPosition);
                }
            }
        });

        addData(getOptions());
    }

    public void addData(CharSequence[] options) {
        if (options == null || options.length == 0) {
            return;
        }
        mDatas.clear();
        for (int i = 0; i < options.length; i++) {
            Map<String, String> listItem = new HashMap<>();
            listItem.put(PARAM_ITEM, options[i].toString());
            mDatas.add(listItem);
        }
        mAdapter.notifyDataSetChanged();
    }

    /**
     * 显示Dialog
     *
     * @param position
     */
    public void show(int position) {
        super.show();
        mItemPosition = position;
    }

    public interface onItemClickListener {
        /**
         * item点击事件回调
         *
         * @param view         当前点击view
         * @param position     当前点击item位置
         * @param itemPosition dialog关联item位置
         */
        void onItemClick(View view, int position, int itemPosition);
    }

    public abstract CharSequence[] getOptions();
}
