/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.base.di.component;

import android.content.Context;
import com.google.gson.Gson;
import com.xdja.im.base.di.component.ApplicationComponent;
import com.xdja.im.base.di.module.ApplicationModule;
import com.xdja.im.base.di.module.ApplicationModule_ProvideApplicationContextFactory;
import com.xdja.im.base.di.module.CacheModule;
import com.xdja.im.base.di.module.CacheModule_ProvideCardCacheFactory;
import com.xdja.im.base.di.module.CacheModule_ProvideConfigCacheFactory;
import com.xdja.im.base.di.module.CacheModule_ProvidePropertyCacheFactory;
import com.xdja.im.base.di.module.CacheModule_ProvideUserCacheFactory;
import com.xdja.im.base.di.module.HttpModule;
import com.xdja.im.base.di.module.HttpModule_ProvideOkHttpsClientFactory;
import com.xdja.im.base.di.module.ImageLoaderModule;
import com.xdja.im.base.di.module.ImageLoaderModule_ProvideImageLoaderFactory;
import com.xdja.im.base.di.module.UtilModule;
import com.xdja.im.base.di.module.UtilModule_ProvideCommonToolFactory;
import com.xdja.im.base.di.module.UtilModule_ProvideGsonFactory;
import com.xdja.im.common.cache.impl.CardCacheImpl_Factory;
import com.xdja.im.common.cache.impl.ConfigCacheImpl;
import com.xdja.im.common.cache.impl.ConfigCacheImpl_Factory;
import com.xdja.im.common.cache.impl.PropertyCacheImpl;
import com.xdja.im.common.cache.impl.PropertyCacheImpl_Factory;
import com.xdja.im.common.cache.impl.UserCacheImpl_Factory;
import com.xdja.im.common.cache.interf.CardCache;
import com.xdja.im.common.cache.interf.ConfigCache;
import com.xdja.im.common.cache.interf.PropertyCache;
import com.xdja.im.common.cache.interf.UserCache;
import com.xdja.im.common.imageloader.ImageLoader;
import com.xdja.im.common.network.OkHttpsClientMe;
import com.xdja.im.common.network.OkHttpsClientMe_Factory;
import com.xdja.im.common.persistent.PropertyUtil;
import com.xdja.im.common.persistent.PropertyUtil_Factory;
import com.xdja.im.common.utils.CommonTool;
import dagger.MembersInjector;
import dagger.internal.DoubleCheck;
import dagger.internal.MembersInjectors;
import dagger.internal.Preconditions;
import javax.inject.Provider;
import okhttp3.OkHttpClient;

public final class DaggerApplicationComponent
implements ApplicationComponent {
    private Provider<Context> provideApplicationContextProvider;
    private Provider<UserCache> provideUserCacheProvider;
    private Provider<CardCache> provideCardCacheProvider;
    private Provider<PropertyUtil> propertyUtilProvider;
    private Provider<ConfigCacheImpl> configCacheImplProvider;
    private Provider<ConfigCache> provideConfigCacheProvider;
    private Provider<PropertyCacheImpl> propertyCacheImplProvider;
    private Provider<PropertyCache> providePropertyCacheProvider;
    private Provider<OkHttpsClientMe> okHttpsClientMeProvider;
    private Provider<OkHttpClient> provideOkHttpsClientProvider;
    private Provider<Gson> provideGsonProvider;
    private Provider<CommonTool> provideCommonToolProvider;
    private Provider<ImageLoader> provideImageLoaderProvider;

    private DaggerApplicationComponent(Builder builder) {
        assert (builder != null);
        this.initialize(builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ApplicationComponent create() {
        return DaggerApplicationComponent.builder().build();
    }

    private void initialize(Builder builder) {
        this.provideApplicationContextProvider = DoubleCheck.provider(ApplicationModule_ProvideApplicationContextFactory.create(builder.applicationModule));
        this.provideUserCacheProvider = DoubleCheck.provider(CacheModule_ProvideUserCacheFactory.create(builder.cacheModule, UserCacheImpl_Factory.create()));
        this.provideCardCacheProvider = DoubleCheck.provider(CacheModule_ProvideCardCacheFactory.create(builder.cacheModule, CardCacheImpl_Factory.create()));
        this.propertyUtilProvider = PropertyUtil_Factory.create(this.provideApplicationContextProvider);
        this.configCacheImplProvider = ConfigCacheImpl_Factory.create(this.propertyUtilProvider);
        this.provideConfigCacheProvider = DoubleCheck.provider(CacheModule_ProvideConfigCacheFactory.create(builder.cacheModule, this.configCacheImplProvider));
        this.propertyCacheImplProvider = PropertyCacheImpl_Factory.create(this.propertyUtilProvider);
        this.providePropertyCacheProvider = DoubleCheck.provider(CacheModule_ProvidePropertyCacheFactory.create(builder.cacheModule, this.propertyCacheImplProvider));
        this.okHttpsClientMeProvider = OkHttpsClientMe_Factory.create((MembersInjector<OkHttpsClientMe>)MembersInjectors.noOp(), this.provideApplicationContextProvider, this.provideUserCacheProvider);
        this.provideOkHttpsClientProvider = DoubleCheck.provider(HttpModule_ProvideOkHttpsClientFactory.create(builder.httpModule, this.okHttpsClientMeProvider));
        this.provideGsonProvider = DoubleCheck.provider(UtilModule_ProvideGsonFactory.create(builder.utilModule));
        this.provideCommonToolProvider = DoubleCheck.provider(UtilModule_ProvideCommonToolFactory.create(builder.utilModule, this.provideApplicationContextProvider));
        this.provideImageLoaderProvider = DoubleCheck.provider(ImageLoaderModule_ProvideImageLoaderFactory.create(builder.imageLoaderModule));
    }

    @Override
    public Context context() {
        return (Context)this.provideApplicationContextProvider.get();
    }

    @Override
    public UserCache accountCache() {
        return (UserCache)this.provideUserCacheProvider.get();
    }

    @Override
    public CardCache cardCache() {
        return (CardCache)this.provideCardCacheProvider.get();
    }

    @Override
    public ConfigCache configCache() {
        return (ConfigCache)this.provideConfigCacheProvider.get();
    }

    @Override
    public PropertyCache propertyCache() {
        return (PropertyCache)this.providePropertyCacheProvider.get();
    }

    @Override
    public OkHttpClient okHttpsClient() {
        return (OkHttpClient)this.provideOkHttpsClientProvider.get();
    }

    @Override
    public Gson gson() {
        return (Gson)this.provideGsonProvider.get();
    }

    @Override
    public CommonTool commonTool() {
        return (CommonTool)this.provideCommonToolProvider.get();
    }

    @Override
    public ImageLoader imageLoader() {
        return (ImageLoader)this.provideImageLoaderProvider.get();
    }

    public static final class Builder {
        private ApplicationModule applicationModule;
        private CacheModule cacheModule;
        private HttpModule httpModule;
        private UtilModule utilModule;
        private ImageLoaderModule imageLoaderModule;

        private Builder() {
        }

        public ApplicationComponent build() {
            if (this.applicationModule == null) {
                this.applicationModule = new ApplicationModule();
            }
            if (this.cacheModule == null) {
                this.cacheModule = new CacheModule();
            }
            if (this.httpModule == null) {
                this.httpModule = new HttpModule();
            }
            if (this.utilModule == null) {
                this.utilModule = new UtilModule();
            }
            if (this.imageLoaderModule == null) {
                this.imageLoaderModule = new ImageLoaderModule();
            }
            return new DaggerApplicationComponent(this);
        }

        public Builder applicationModule(ApplicationModule applicationModule) {
            this.applicationModule = (ApplicationModule)Preconditions.checkNotNull((Object)applicationModule);
            return this;
        }

        public Builder cacheModule(CacheModule cacheModule) {
            this.cacheModule = (CacheModule)Preconditions.checkNotNull((Object)cacheModule);
            return this;
        }

        public Builder httpModule(HttpModule httpModule) {
            this.httpModule = (HttpModule)Preconditions.checkNotNull((Object)httpModule);
            return this;
        }

        public Builder utilModule(UtilModule utilModule) {
            this.utilModule = (UtilModule)Preconditions.checkNotNull((Object)utilModule);
            return this;
        }

        public Builder imageLoaderModule(ImageLoaderModule imageLoaderModule) {
            this.imageLoaderModule = (ImageLoaderModule)Preconditions.checkNotNull((Object)imageLoaderModule);
            return this;
        }
    }
}

