/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.base.executor;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import rx.Scheduler;
import rx.schedulers.Schedulers;

public class ThreadExecutor
implements Executor {
    private static final int INITIAL_POOL_SIZE = 3;
    private static final int MAX_POOL_SIZE = 5;
    private static final int KEEP_ALIVE_TIME = 10;
    private static final TimeUnit KEEP_ALIVE_TIME_UNIT = TimeUnit.SECONDS;
    @NonNull
    private final BlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>();
    @NonNull
    private final ThreadPoolExecutor threadPoolExecutor;
    @NonNull
    private final ThreadFactory threadFactory = new JobThreadFactory();

    @Inject
    public ThreadExecutor() {
        this.threadPoolExecutor = new ThreadPoolExecutor(3, 5, 10L, KEEP_ALIVE_TIME_UNIT, this.workQueue, this.threadFactory);
    }

    @Override
    public void execute(@Nullable Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Runnable to execute cannot be null");
        }
        this.threadPoolExecutor.execute(runnable);
    }

    public void submite(@Nullable Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Runnable to submite cannot be null");
        }
        this.threadPoolExecutor.submit(runnable);
    }

    public Scheduler getScheduler() {
        return Schedulers.from((Executor)this);
    }

    private static class JobThreadFactory
    implements ThreadFactory {
        private static final String THREAD_NAME = "android_";
        private int counter = 0;

        private JobThreadFactory() {
        }

        @Override
        @NonNull
        public Thread newThread(Runnable runnable) {
            return new Thread(runnable, THREAD_NAME + this.counter);
        }
    }
}

