/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.base.frame.view;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.xdja.im.base.frame.BaseView;
import com.xdja.im.base.frame.Presenter;
import com.xdja.im.base.frame.annotation.ContentView;

public class SuperBaseView<P extends Presenter>
implements BaseView<P> {
    private View view;
    private P presenter;
    private Activity activity;

    @Override
    public void init(LayoutInflater inflater, ViewGroup container) {
        ContentView contentView = this.getClass().getAnnotation(ContentView.class);
        this.view = contentView != null ? inflater.inflate(contentView.value(), container, false) : inflater.inflate(this.getLayoutRes(), container, false);
        this.injectView();
    }

    @LayoutRes
    protected int getLayoutRes() {
        return 0;
    }

    protected void injectView() {
    }

    @Override
    public View getView() {
        return this.view;
    }

    @Override
    public void setPresenter(P presenter) {
        this.presenter = presenter;
    }

    @Override
    public <A extends Activity> void setActivity(A activity) {
        this.activity = activity;
    }

    public Activity getActivity() {
        return this.activity;
    }

    public Context getContext() {
        return this.activity;
    }

    public P getPresenter() {
        return this.presenter;
    }

    public View findViewById(int resId) {
        return this.view.findViewById(resId);
    }

    public Resources getResources() {
        return this.getContext().getResources();
    }

    @NonNull
    public String getStringRes(@StringRes int res) {
        return this.getContext().getString(res);
    }

    public int getColorRes(@ColorRes int res) {
        return this.getContext().getResources().getColor(res);
    }

    @Nullable
    public Drawable getDrawableRes(@DrawableRes int res) {
        return this.getContext().getResources().getDrawable(res);
    }

    @Nullable
    public int getDimensRes(@DimenRes int res) {
        return this.getContext().getResources().getDimensionPixelOffset(res);
    }
}

