/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.common.exception;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Environment;
import android.os.Process;
import com.xdja.im.uikit.utils.log.LogUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class CrashHandler
implements Thread.UncaughtExceptionHandler {
    private static final boolean DEBUG = true;
    private static final String FILE_NAME = "crash";
    private static final String FILE_NAME_SUFFIX = ".txt";
    private Context mContext;
    private static String mCrashPath;
    private Thread.UncaughtExceptionHandler mDefaultCrashHandler;

    private CrashHandler() {
    }

    public static CrashHandler getInstance() {
        return CrashHandlerInstance.mInstance;
    }

    public void init(Context context) {
        this.mDefaultCrashHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(this);
        this.mContext = context.getApplicationContext();
        mCrashPath = Environment.getExternalStorageDirectory() + File.separator + "CrashLog" + File.separator + "log";
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        try {
            this.dumpExceptionToSDCard(throwable);
            this.uploadExceptionToServer();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        throwable.printStackTrace();
        if (this.mDefaultCrashHandler != null) {
            this.mDefaultCrashHandler.uncaughtException(thread, throwable);
        } else {
            Process.killProcess((int)Process.myPid());
        }
    }

    private void dumpExceptionToSDCard(Throwable throwable) throws IOException {
        if (!Environment.getExternalStorageState().equals("mounted")) {
            LogUtil.w("sdcard unmounted,skip dump exception");
            return;
        }
        File dir = new File(mCrashPath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        long current = System.currentTimeMillis();
        String time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(current));
        String fileName = FILE_NAME + time + FILE_NAME_SUFFIX;
        File file = new File(mCrashPath, fileName);
        try {
            PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            pw.println(time);
            this.dumpPhoneInfo(pw);
            pw.println();
            throwable.printStackTrace(pw);
            pw.close();
        }
        catch (IOException e) {
            LogUtil.e("dump crash info failed");
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void dumpPhoneInfo(PrintWriter pw) throws PackageManager.NameNotFoundException {
        PackageManager pm = this.mContext.getPackageManager();
        PackageInfo pi = pm.getPackageInfo(this.mContext.getPackageName(), 1);
        pw.write("App Version\uff1a");
        pw.print(pi.versionName);
        pw.print('_');
        pw.println(pi.versionCode);
        pw.print("OS Version\uff1a ");
        pw.print(Build.VERSION.RELEASE);
        pw.print('_');
        pw.println(Build.VERSION.SDK_INT);
        pw.print("Model\uff1a ");
        pw.println(Build.MANUFACTURER);
        pw.print("Model\uff1a ");
        pw.println(Build.MODEL);
        pw.print("CPU ABI\uff1a");
        pw.println(Build.CPU_ABI);
    }

    private void uploadExceptionToServer() {
    }

    private static class CrashHandlerInstance {
        private static final CrashHandler mInstance = new CrashHandler();

        private CrashHandlerInstance() {
        }
    }
}

