/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.common.imageloader;

import android.content.Context;
import com.bumptech.glide.Glide;
import com.bumptech.glide.GlideBuilder;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.engine.bitmap_recycle.LruBitmapPool;
import com.bumptech.glide.load.engine.cache.DiskCache;
import com.bumptech.glide.load.engine.cache.DiskLruCacheFactory;
import com.bumptech.glide.load.engine.cache.LruResourceCache;
import com.bumptech.glide.load.engine.cache.MemoryCache;
import com.bumptech.glide.load.engine.cache.MemorySizeCalculator;
import com.bumptech.glide.module.GlideModule;
import java.io.File;

public class CustomCacheGlideModule
implements GlideModule {
    public void applyOptions(Context context, GlideBuilder glideBuilder) {
        MemorySizeCalculator calculator = new MemorySizeCalculator(context);
        int defaultMemoryCacheSize = calculator.getMemoryCacheSize();
        int defaultBitmapPoolSize = calculator.getBitmapPoolSize();
        int customMemoryCacheSize = (int)(1.2 * (double)defaultMemoryCacheSize);
        int customBitmapPoolSize = (int)(1.2 * (double)defaultBitmapPoolSize);
        glideBuilder.setMemoryCache((MemoryCache)new LruResourceCache(customMemoryCacheSize));
        glideBuilder.setBitmapPool((BitmapPool)new LruBitmapPool(customBitmapPoolSize));
        String downloadDirectoryPath = context.getCacheDir().getParent() + File.separator + "xdja_uikit" + File.separator + "cache" + File.separator + "image_manager_disk_cache";
        int diskCacheSize = 0x32000000;
        glideBuilder.setDiskCache((DiskCache.Factory)new DiskLruCacheFactory(downloadDirectoryPath, diskCacheSize));
    }

    public void registerComponents(Context context, Glide glide) {
    }
}

