/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.common.persistent;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.Nullable;
import com.xdja.im.base.di.scope.Scoped;
import com.xdja.im.common.cache.interf.UserCache;
import javax.inject.Inject;

public class PreferencesUtil {
    private SharedPreferences sp;
    private SharedPreferences.Editor sharedEditor;

    @Inject
    public PreferencesUtil(@Scoped(value="application") Context context, UserCache userCache) {
        String account = userCache.get().getAccount();
        this.sp = context.getSharedPreferences("configuration_" + account, 0);
        this.sharedEditor = this.sp.edit();
    }

    public boolean setPreferenceStringValue(String key, String value) {
        if (this.sharedEditor == null) {
            SharedPreferences.Editor editor = this.sp.edit();
            editor.putString(key, value);
            return editor.commit();
        }
        this.sharedEditor.putString(key, value);
        return this.sharedEditor.commit();
    }

    public boolean setPreferenceBooleanValue(String key, boolean value) {
        if (this.sharedEditor == null) {
            SharedPreferences.Editor editor = this.sp.edit();
            editor.putBoolean(key, value);
            return editor.commit();
        }
        this.sharedEditor.putBoolean(key, value);
        return this.sharedEditor.commit();
    }

    public boolean setPreferenceFloatValue(String key, float value) {
        if (this.sharedEditor == null) {
            SharedPreferences.Editor editor = this.sp.edit();
            editor.putFloat(key, value);
            return editor.commit();
        }
        this.sharedEditor.putFloat(key, value);
        return this.sharedEditor.commit();
    }

    public boolean setPreferenceIntValue(String key, int value) {
        if (this.sharedEditor == null) {
            SharedPreferences.Editor editor = this.sp.edit();
            editor.putInt(key, value);
            return editor.commit();
        }
        this.sharedEditor.putInt(key, value);
        return this.sharedEditor.commit();
    }

    public String gPrefStringValue(@Nullable String key) {
        return this.sp.getString(key, "");
    }

    public Boolean gPrefBooleanValue(@Nullable String key, boolean defaultValue) {
        return this.sp.getBoolean(key, defaultValue);
    }

    public int gPrefIntValue(@Nullable String key) {
        return this.sp.getInt(key, 0);
    }

    public long gPrefLongValue(@Nullable String key) {
        return this.sp.getLong(key, 0L);
    }

    public float gPrefFloatValue(@Nullable String key) {
        return this.sp.getFloat(key, 0.0f);
    }
}

