/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.common.persistent;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.xdja.im.base.di.scope.Scoped;
import com.xdja.im.uikit.utils.log.LogUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.inject.Inject;

public class PropertyUtil {
    private Context context;
    private Properties properties;

    @Inject
    public PropertyUtil(@Scoped(value="application") @NonNull Context context) {
        this.context = context;
    }

    public void load(@NonNull String fileName) {
        if (TextUtils.isEmpty((CharSequence)fileName)) {
            LogUtil.e("ERROR: Load file name is null.");
            return;
        }
        try {
            InputStream is = this.context.getAssets().open(fileName);
            this.properties = new Properties();
            this.properties.load(is);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String get(@NonNull String name) {
        if (this.properties != null && !TextUtils.isEmpty((CharSequence)name)) {
            return this.properties.getProperty(name);
        }
        return null;
    }

    public String get(@NonNull String name, @Nullable String defaultValue) {
        if (this.properties != null && !TextUtils.isEmpty((CharSequence)name)) {
            return this.properties.getProperty(name, defaultValue);
        }
        return null;
    }

    public Map<String, String> getAll() {
        Set<String> keys;
        if (this.properties != null && (keys = this.properties.stringPropertyNames()) != null && !keys.isEmpty()) {
            HashMap<String, String> kv = new HashMap<String, String>();
            for (String key : keys) {
                String value = this.properties.getProperty(key);
                kv.put(key, value);
            }
            return kv;
        }
        return null;
    }
}

