/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.common.router;

import android.content.Context;
import com.xdja.im.common.router.IntentWrapper;
import com.xdja.im.common.router.Interceptor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public final class LiteRouter {
    private Interceptor interceptor;

    LiteRouter(Interceptor interceptor) {
        this.interceptor = interceptor;
    }

    public <T> T create(Class<T> service, final Context context) {
        return (T)Proxy.newProxyInstance(service.getClassLoader(), new Class[]{service}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object ... args) throws Throwable {
                IntentWrapper intentWrapper = LiteRouter.this.loadIntentWrapper(context, method, args);
                Class<?> returnTYpe = method.getReturnType();
                if (returnTYpe == Void.TYPE) {
                    if (LiteRouter.this.interceptor == null || !LiteRouter.this.interceptor.intercept(intentWrapper)) {
                        intentWrapper.start();
                    }
                    return null;
                }
                if (returnTYpe == IntentWrapper.class) {
                    return intentWrapper;
                }
                throw new RuntimeException("method return type only support 'void' or 'IntentWrapper'");
            }
        });
    }

    IntentWrapper loadIntentWrapper(Context context, Method method, Object ... args) {
        return new IntentWrapper.Builder(context, method, args).build();
    }

    public static final class Builder {
        private Interceptor interceptor;

        public Builder interceptor(Interceptor interceptor) {
            this.interceptor = interceptor;
            return this;
        }

        public LiteRouter build() {
            return new LiteRouter(this.interceptor);
        }
    }
}

