/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.core.repository.impl.datasource;

import com.xdja.im.common.database.helper.IMSettingHelper;
import com.xdja.im.common.database.helper.MXSettingHelper;
import com.xdja.im.common.persistent.PreferencesUtil;
import com.xdja.im.core.model.param.SessionParam;
import com.xdja.im.core.model.param.SettingParam;
import com.xdja.im.core.repository.interf.datasource.DiskDataStore;
import java.util.List;
import javax.inject.Inject;
import rx.Observable;
import rx.Subscriber;
import rx.android.schedulers.AndroidSchedulers;
import rx.functions.Func1;
import rx.schedulers.Schedulers;

public class DiskDataStoreImpl
implements DiskDataStore {
    private PreferencesUtil preferencesUtil;

    @Inject
    public DiskDataStoreImpl(PreferencesUtil preferencesUtil) {
        this.preferencesUtil = preferencesUtil;
    }

    @Override
    public void setSessionTop(String sessionFlag, final boolean isTop, Subscriber<Boolean> subscriber) {
        Observable.just((Object)sessionFlag).subscribeOn(Schedulers.newThread()).flatMap((Func1)new Func1<String, Observable<Boolean>>(){

            public Observable<Boolean> call(String sessionFlag) {
                boolean ret = MXSettingHelper.setSessionTop(sessionFlag, isTop);
                if (!ret) {
                    return Observable.error((Throwable)new Exception("Save session error."));
                }
                return Observable.just((Object)ret);
            }
        }).observeOn(AndroidSchedulers.mainThread()).subscribe(subscriber);
    }

    @Override
    public void setSessionDisturb(String sessionFlag, final boolean isDisturb, Subscriber<Boolean> subscriber) {
        Observable.just((Object)sessionFlag).subscribeOn(Schedulers.newThread()).flatMap((Func1)new Func1<String, Observable<Boolean>>(){

            public Observable<Boolean> call(String sessionFlag) {
                boolean ret = MXSettingHelper.setSessionDisturb(sessionFlag, isDisturb);
                if (!ret) {
                    return Observable.error((Throwable)new Exception("Save session error."));
                }
                return Observable.just((Object)ret);
            }
        }).observeOn(AndroidSchedulers.mainThread()).subscribe(subscriber);
    }

    @Override
    public void setReceiveMode(String sessionFlag, final boolean isOpen, Subscriber<Boolean> subscriber) {
        Observable.just((Object)sessionFlag).subscribeOn(Schedulers.newThread()).flatMap((Func1)new Func1<String, Observable<Boolean>>(){

            public Observable<Boolean> call(String sessionFlag) {
                boolean ret = MXSettingHelper.setReceiveMode(sessionFlag, isOpen);
                if (!ret) {
                    return Observable.error((Throwable)new Exception("Save session error."));
                }
                return Observable.just((Object)ret);
            }
        }).observeOn(AndroidSchedulers.mainThread()).subscribe(subscriber);
    }

    @Override
    public void saveDraftContent(String sessionFlag, final String content, final long draftTime, Subscriber<Boolean> subscriber) {
        Observable.just((Object)sessionFlag).subscribeOn(Schedulers.newThread()).flatMap((Func1)new Func1<String, Observable<Boolean>>(){

            public Observable<Boolean> call(String sessionFlag) {
                boolean ret = MXSettingHelper.insertDraft(sessionFlag, content, draftTime);
                if (!ret) {
                    return Observable.error((Throwable)new Exception("Save draft error."));
                }
                return Observable.just((Object)ret);
            }
        }).observeOn(AndroidSchedulers.mainThread()).subscribe(subscriber);
    }

    @Override
    public void clearDraftContent(String sessionFlag, final long draftTime, Subscriber<Boolean> subscriber) {
        Observable.just((Object)sessionFlag).subscribeOn(Schedulers.newThread()).flatMap((Func1)new Func1<String, Observable<Boolean>>(){

            public Observable<Boolean> call(String sessionFlag) {
                boolean ret = MXSettingHelper.clearDraft(sessionFlag, draftTime);
                if (!ret) {
                    return Observable.error((Throwable)new Exception("Clear draft error."));
                }
                return Observable.just((Object)ret);
            }
        }).observeOn(AndroidSchedulers.mainThread()).subscribe(subscriber);
    }

    @Override
    public void getDraftContent(String sessionFlag, Subscriber<String> subscriber) {
        Observable.just((Object)sessionFlag).subscribeOn(Schedulers.newThread()).flatMap((Func1)new Func1<String, Observable<String>>(){

            public Observable<String> call(String sessionFlag) {
                String content = MXSettingHelper.getDraftContent(sessionFlag);
                return Observable.just((Object)content);
            }
        }).observeOn(AndroidSchedulers.mainThread()).subscribe(subscriber);
    }

    @Override
    public void loadSessionParam(String sessionFlag, Subscriber<SessionParam> subscriber) {
        Observable.just((Object)sessionFlag).subscribeOn(Schedulers.newThread()).flatMap((Func1)new Func1<String, Observable<SessionParam>>(){

            public Observable<SessionParam> call(String sessionFlag) {
                SessionParam param = MXSettingHelper.getSessionParam(sessionFlag);
                if (param == null) {
                    return Observable.error((Throwable)new Exception("Load session param is null."));
                }
                return Observable.just((Object)param);
            }
        }).observeOn(AndroidSchedulers.mainThread()).subscribe(subscriber);
    }

    @Override
    public void loadAllSessionParams(Subscriber<List<SessionParam>> subscriber) {
        Observable.just((Object)"").subscribeOn(Schedulers.newThread()).flatMap((Func1)new Func1<String, Observable<List<SessionParam>>>(){

            public Observable<List<SessionParam>> call(String s) {
                List<SessionParam> params = MXSettingHelper.getAllSessionParams();
                return Observable.just(params);
            }
        }).observeOn(AndroidSchedulers.mainThread()).subscribe(subscriber);
    }

    @Override
    public void deleteSessionParam(final String sessionFlag, Subscriber<Boolean> subscriber) {
        Observable.just((Object)sessionFlag).subscribeOn(Schedulers.newThread()).flatMap((Func1)new Func1<String, Observable<Boolean>>(){

            public Observable<Boolean> call(String s) {
                MXSettingHelper.deleteOnlyDraft(sessionFlag);
                return Observable.just((Object)true);
            }
        }).observeOn(AndroidSchedulers.mainThread()).subscribe(subscriber);
    }

    @Override
    public void deleteAllSessionParams(Subscriber<Boolean> subscriber) {
        Observable.just((Object)"").subscribeOn(Schedulers.newThread()).flatMap((Func1)new Func1<String, Observable<Boolean>>(){

            public Observable<Boolean> call(String s) {
                boolean ret = MXSettingHelper.deleteAllSessionParams();
                if (!ret) {
                    return Observable.error((Throwable)new Exception("Save session error."));
                }
                return Observable.just((Object)ret);
            }
        }).observeOn(AndroidSchedulers.mainThread()).subscribe(subscriber);
    }

    @Override
    public void loadSettingParams(Subscriber<SettingParam> subscriber) {
        Observable.just((Object)"").subscribeOn(Schedulers.newThread()).flatMap((Func1)new Func1<String, Observable<SettingParam>>(){

            public Observable<SettingParam> call(String s) {
                SettingParam settingParam = IMSettingHelper.getSettingParam();
                if (settingParam == null) {
                    return Observable.error((Throwable)new Exception("Save session error."));
                }
                return Observable.just((Object)settingParam);
            }
        }).observeOn(AndroidSchedulers.mainThread()).subscribe(subscriber);
    }
}

