/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.action;

import android.content.Context;
import android.support.annotation.Nullable;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.xdja.im.lib.action.listener.IChatActionCallback;
import com.xdja.im.lib.audio.widget.AudioRecorderButton;
import com.xdja.im.lib.emoji.utils.EmotionUtils;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.view.PastEditText;

public class ChatInputView
extends LinearLayout {
    private final int MAX_INPUT_SIZE = 2048;
    private ImageView mMoreImg;
    private ImageView mShanImg;
    private CheckBox mInputSwitchChx;
    private PastEditText mInputEdt;
    private AudioRecorderButton mRecorderBtn;
    private Button mSendBtn;
    boolean isTouchEditText;

    public ChatInputView(Context context) {
        super(context);
        this.initView();
    }

    public ChatInputView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public ChatInputView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    private void initView() {
        View.inflate((Context)this.getContext(), (int)R.layout.im_uikit_layout_chat_operate, (ViewGroup)this);
        this.mMoreImg = (ImageView)this.findViewById(R.id.img_more_action);
        this.mShanImg = (ImageView)this.findViewById(R.id.img_shan_action);
        this.mInputSwitchChx = (CheckBox)this.findViewById(R.id.chx_input_switch);
        this.mInputEdt = (PastEditText)this.findViewById(R.id.edt_input_text);
        this.mRecorderBtn = (AudioRecorderButton)this.findViewById(R.id.btn_input_voice);
        this.mSendBtn = (Button)this.findViewById(R.id.btn_send);
    }

    public void registerActionViewCallBack(final IChatActionCallback callback) {
        this.mInputEdt.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                int length = s.toString().length();
                if (length >= 2048) {
                    s = s.delete(2048, length);
                }
                if (s.length() == 0) {
                    ChatInputView.this.mSendBtn.setVisibility(8);
                    ChatInputView.this.mMoreImg.setVisibility(0);
                } else {
                    ChatInputView.this.mSendBtn.setVisibility(0);
                    ChatInputView.this.mMoreImg.setVisibility(8);
                }
            }
        });
        this.mInputEdt.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                ChatInputView.this.mInputEdt.setFocusable(true);
                ChatInputView.this.mInputEdt.setFocusableInTouchMode(true);
                ChatInputView.this.mInputEdt.requestFocus();
                if (!TextUtils.isEmpty((CharSequence)ChatInputView.this.getInputText())) {
                    ChatInputView.this.mSendBtn.setVisibility(0);
                    ChatInputView.this.mMoreImg.setVisibility(8);
                }
                if (event.getAction() == 1) {
                    ChatInputView.this.isTouchEditText = true;
                    ChatInputView.this.mMoreImg.setImageResource(R.mipmap.im_uikit_action_chat_panel_normal);
                    callback.onInputEareTouchCallBack();
                }
                return false;
            }
        });
        this.mInputSwitchChx.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                ChatInputView.this.switchToInputEdt(!isChecked);
                callback.onInputCheckChanged(!isChecked);
            }
        });
        this.mShanImg.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChatInputView.this.setMoreState(false);
                ChatInputView.this.switchToInputEdt(true);
                ChatInputView.this.mInputSwitchChx.setChecked(false);
                callback.onShanCheckChanged();
            }
        });
        this.mMoreImg.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChatInputView.this.setShanState(false);
                ChatInputView.this.switchToInputEdt(true);
                ChatInputView.this.mInputSwitchChx.setChecked(false);
                callback.onMoreCheckChanged();
            }
        });
        this.mSendBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                callback.onSendTextCallBack();
            }
        });
        this.mRecorderBtn.setAudioFinishRecorderListener(new AudioRecorderButton.AudioFinishRecorderListener(){

            @Override
            public void onFinish(float seconds, String filePath) {
                callback.onRecorderFinish((int)seconds, filePath);
            }
        });
    }

    public void switchToInputEdt(boolean isSwitch) {
        if (isSwitch) {
            this.mInputEdt.setVisibility(0);
            this.mRecorderBtn.setVisibility(8);
            this.mInputEdt.requestFocus();
            if (this.getInputEdt().length() == 0) {
                this.mSendBtn.setVisibility(8);
                this.mMoreImg.setVisibility(0);
            } else {
                this.mSendBtn.setVisibility(0);
                this.mMoreImg.setVisibility(8);
            }
        } else {
            this.mInputEdt.setVisibility(8);
            this.mRecorderBtn.setVisibility(0);
            this.mSendBtn.setVisibility(8);
            this.mMoreImg.setVisibility(0);
        }
    }

    public String getInputText() {
        return this.mInputEdt.getText().toString();
    }

    public void setInputText(CharSequence text) {
        this.mInputEdt.setText((CharSequence)EmotionUtils.formatSpanContent(text, this.getContext(), 1.1f));
        this.mInputEdt.setFocusable(true);
        this.mInputEdt.setFocusableInTouchMode(true);
        this.mInputEdt.requestFocus();
    }

    public EditText getInputEdt() {
        return this.mInputEdt;
    }

    public void setMoreState(boolean isChecked) {
        if (!TextUtils.isEmpty((CharSequence)this.getInputText()) && this.mInputEdt.isShown()) {
            this.mMoreImg.setVisibility(8);
            this.mSendBtn.setVisibility(0);
            this.mInputEdt.requestFocus();
        } else {
            this.mSendBtn.setVisibility(8);
            this.mMoreImg.setVisibility(0);
            if (isChecked) {
                this.mMoreImg.setImageResource(R.mipmap.im_uikit_actioin_chat_panel_press);
            } else {
                this.mMoreImg.setImageResource(R.mipmap.im_uikit_action_chat_panel_normal);
            }
        }
    }

    public void setShanState(boolean isChecked) {
        if (isChecked) {
            this.mShanImg.setImageResource(R.mipmap.im_uikit_action_chat_keyinput_normal);
        } else {
            this.mShanImg.setImageResource(R.mipmap.im_uikit_action_chat_emotion_normal);
        }
    }
}

