/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.action.recycler;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.support.v7.widget.RecyclerView;
import android.view.MotionEvent;
import android.view.View;

public class PageScrollHelper {
    private RecyclerView mRecyclerView = null;
    private MyOnScrollListener mOnScrollListener = new MyOnScrollListener();
    private MyOnFlingListener mOnFlingListener = new MyOnFlingListener();
    private int offsetY = 0;
    private int offsetX = 0;
    private int startY = 0;
    private int startX = 0;
    ORIENTATION mOrientation = ORIENTATION.HORIZONTAL;
    ValueAnimator mAnimator = null;
    private MyOnTouchListener mOnTouchListener = new MyOnTouchListener();
    onPageChangeListener mOnPageChangeListener;

    public void setUpRecycleView(RecyclerView recycleView) {
        if (recycleView == null) {
            throw new IllegalArgumentException("recycleView must be not null");
        }
        this.mRecyclerView = recycleView;
        recycleView.setOnFlingListener((RecyclerView.OnFlingListener)this.mOnFlingListener);
        recycleView.setOnScrollListener((RecyclerView.OnScrollListener)this.mOnScrollListener);
        recycleView.setOnTouchListener((View.OnTouchListener)this.mOnTouchListener);
        this.updateLayoutManger();
    }

    public void updateLayoutManger() {
        RecyclerView.LayoutManager layoutManager = this.mRecyclerView.getLayoutManager();
        if (layoutManager != null) {
            this.mOrientation = layoutManager.canScrollVertically() ? ORIENTATION.VERTICAL : (layoutManager.canScrollHorizontally() ? ORIENTATION.HORIZONTAL : ORIENTATION.NULL);
            if (this.mAnimator != null) {
                this.mAnimator.cancel();
            }
            this.startX = 0;
            this.startY = 0;
            this.offsetX = 0;
            this.offsetY = 0;
        }
    }

    private int getPageIndex() {
        int p = 0;
        p = this.mOrientation == ORIENTATION.VERTICAL ? this.offsetY / this.mRecyclerView.getHeight() : this.offsetX / this.mRecyclerView.getWidth();
        return p;
    }

    private int getStartPageIndex() {
        int p = 0;
        p = this.mOrientation == ORIENTATION.VERTICAL ? this.startY / this.mRecyclerView.getHeight() : this.startX / this.mRecyclerView.getWidth();
        return p;
    }

    public void setOnPageChangeListener(onPageChangeListener listener) {
        this.mOnPageChangeListener = listener;
    }

    public static interface onPageChangeListener {
        public void onPageChange(int var1);
    }

    public class MyOnTouchListener
    implements View.OnTouchListener {
        public boolean onTouch(View v, MotionEvent event) {
            if (event.getAction() == 0) {
                PageScrollHelper.this.startY = PageScrollHelper.this.offsetY;
                PageScrollHelper.this.startX = PageScrollHelper.this.offsetX;
            }
            return false;
        }
    }

    public class MyOnScrollListener
    extends RecyclerView.OnScrollListener {
        public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
            if (newState == 0 && PageScrollHelper.this.mOrientation != ORIENTATION.NULL) {
                int vX = 0;
                int vY = 0;
                if (PageScrollHelper.this.mOrientation == ORIENTATION.VERTICAL) {
                    int absY = Math.abs(PageScrollHelper.this.offsetY - PageScrollHelper.this.startY);
                    boolean move = absY > recyclerView.getHeight() / 2;
                    vY = 0;
                    if (move) {
                        vY = PageScrollHelper.this.offsetY - PageScrollHelper.this.startY < 0 ? -1000 : 1000;
                    }
                } else {
                    boolean move;
                    int absX = Math.abs(PageScrollHelper.this.offsetX - PageScrollHelper.this.startX);
                    boolean bl = move = absX > recyclerView.getWidth() / 2;
                    if (move) {
                        vX = PageScrollHelper.this.offsetX - PageScrollHelper.this.startX < 0 ? -1000 : 1000;
                    }
                }
                PageScrollHelper.this.mOnFlingListener.onFling(vX, vY);
            }
        }

        public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
            PageScrollHelper.this.offsetY = PageScrollHelper.this.offsetY + dy;
            PageScrollHelper.this.offsetX = PageScrollHelper.this.offsetX + dx;
        }
    }

    public class MyOnFlingListener
    extends RecyclerView.OnFlingListener {
        public boolean onFling(int velocityX, int velocityY) {
            if (PageScrollHelper.this.mOrientation == ORIENTATION.NULL) {
                return false;
            }
            int p = PageScrollHelper.this.getStartPageIndex();
            int endPoint = 0;
            int startPoint = 0;
            if (PageScrollHelper.this.mOrientation == ORIENTATION.VERTICAL) {
                startPoint = PageScrollHelper.this.offsetY;
                if (velocityY < 0) {
                    --p;
                } else if (velocityY > 0) {
                    ++p;
                }
                endPoint = p * PageScrollHelper.this.mRecyclerView.getHeight();
            } else {
                startPoint = PageScrollHelper.this.offsetX;
                if (velocityX < 0) {
                    --p;
                } else if (velocityX > 0) {
                    ++p;
                }
                endPoint = p * PageScrollHelper.this.mRecyclerView.getWidth();
            }
            if (endPoint < 0) {
                endPoint = 0;
            }
            if (PageScrollHelper.this.mAnimator == null) {
                new ValueAnimator();
                PageScrollHelper.this.mAnimator = ValueAnimator.ofInt((int[])new int[]{startPoint, endPoint});
                PageScrollHelper.this.mAnimator.setDuration(300L);
                PageScrollHelper.this.mAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                    public void onAnimationUpdate(ValueAnimator animation) {
                        int nowPoint = (Integer)animation.getAnimatedValue();
                        if (PageScrollHelper.this.mOrientation == ORIENTATION.VERTICAL) {
                            int dy = nowPoint - PageScrollHelper.this.offsetY;
                            PageScrollHelper.this.mRecyclerView.scrollBy(0, dy);
                        } else {
                            int dx = nowPoint - PageScrollHelper.this.offsetX;
                            PageScrollHelper.this.mRecyclerView.scrollBy(dx, 0);
                        }
                    }
                });
                PageScrollHelper.this.mAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animation) {
                        if (null != PageScrollHelper.this.mOnPageChangeListener) {
                            PageScrollHelper.this.mOnPageChangeListener.onPageChange(PageScrollHelper.this.getPageIndex());
                        }
                    }
                });
            } else {
                PageScrollHelper.this.mAnimator.cancel();
                PageScrollHelper.this.mAnimator.setIntValues(new int[]{startPoint, endPoint});
            }
            PageScrollHelper.this.mAnimator.start();
            return true;
        }
    }

    static enum ORIENTATION {
        HORIZONTAL,
        VERTICAL,
        NULL;

    }
}

