/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.album;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.v4.app.Fragment;
import android.text.TextUtils;
import com.xdja.im.common.imageloader.DefaultImageLoader;
import com.xdja.im.common.imageloader.ImageLoader;
import com.xdja.im.core.utils.FilePathUtils;
import com.xdja.im.lib.album.ImagePickerConfig;
import com.xdja.im.lib.album.ui.activity.ImagePickerActivity;

public class ImagePickerManager {
    public static final String CACHE_PATH = "ImagePicker";
    private ImagePickerConfig mConfig;
    private ImageLoader mImageLoader;

    private ImagePickerManager() {
    }

    public static ImagePickerManager getInstance() {
        return ImagePickerManagerInstance.mInstance;
    }

    public ImagePickerConfig getConfig() {
        if (this.mConfig == null) {
            this.mConfig = new ImagePickerConfig();
        }
        if (TextUtils.isEmpty((CharSequence)this.mConfig.getCachePath())) {
            this.mConfig.setCachePath(FilePathUtils.getImagePath());
        }
        return this.mConfig;
    }

    public void setConfig(ImagePickerConfig config) {
        this.mConfig = config;
    }

    public ImageLoader getImageLoader() {
        if (this.mImageLoader == null) {
            this.mImageLoader = new DefaultImageLoader();
        }
        return this.mImageLoader;
    }

    public void setImageLoader(ImageLoader imageLoader) {
        this.mImageLoader = imageLoader;
    }

    public void openAlbum(Fragment fragment, int requestCode) {
        Intent intent = new Intent();
        intent.setClass(fragment.getContext(), ImagePickerActivity.class);
        fragment.startActivityForResult(intent, requestCode);
    }

    public void openAlbum(Activity activity, int requestCode) {
        Intent intent = new Intent();
        intent.setClass((Context)activity, ImagePickerActivity.class);
        activity.startActivityForResult(intent, requestCode);
    }

    private static class ImagePickerManagerInstance {
        private static ImagePickerManager mInstance = new ImagePickerManager();

        private ImagePickerManagerInstance() {
        }
    }
}

