/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.album.ui.activity;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.MotionEvent;
import com.xdja.im.common.utils.CommonTool;
import com.xdja.im.lib.album.ImageDataSource;
import com.xdja.im.lib.album.bean.ImageItem;
import com.xdja.im.lib.album.bean.ImageThumbBean;
import com.xdja.im.lib.album.ui.adapter.ImagePreviewAdapter;
import com.xdja.im.lib.album.ui.presenter.ImagePreviewPresenter;
import com.xdja.im.lib.album.ui.view.ViewImagePreview;
import com.xdja.im.lib.album.ui.view.vu.ImagePreviewVu;
import com.xdja.im.lib.album.utils.DataTools;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.base.ImBaseActivity;
import com.xdja.im.uikit.utils.log.LogUtil;
import java.util.ArrayList;
import java.util.List;
import rx.Observable;
import rx.Subscriber;
import rx.android.schedulers.AndroidSchedulers;
import rx.functions.Func1;
import rx.schedulers.Schedulers;

public class ImagePreviewActivity
extends ImBaseActivity<ImagePreviewPresenter, ImagePreviewVu>
implements ImagePreviewPresenter {
    public static final int TYPE_ALL = 0;
    public static final int TYPE_SELECTED = 1;
    public static final String TAG_TYPE = "P_Type";
    public static final String TAG_POSITION = "P_Position";
    private ImagePreviewAdapter mAdapter;
    private List<ImageItem> mImageItemList = new ArrayList<ImageItem>();
    private int mCurPosition;
    private boolean bSendingImage = false;

    @Override
    @NonNull
    protected Class<? extends ImagePreviewVu> getVuClass() {
        return ViewImagePreview.class;
    }

    @Override
    @NonNull
    protected ImagePreviewPresenter getPresenter() {
        return this;
    }

    @Override
    protected void onBindView(@Nullable Bundle savedInstanceState) {
        super.onBindView(savedInstanceState);
        int type = this.getIntent().getIntExtra(TAG_TYPE, 0);
        this.mImageItemList.clear();
        if (type == 0) {
            this.mImageItemList.addAll(ImageDataSource.getInstance().getAll());
            this.mCurPosition = this.getIntent().getIntExtra(TAG_POSITION, 0);
        } else {
            this.mImageItemList.addAll(ImageDataSource.getInstance().getSelects());
        }
        this.mAdapter = new ImagePreviewAdapter((Activity)this, this.mImageItemList);
        ((ImagePreviewVu)this.getVu()).setAdapter(this.mAdapter);
        ((ImagePreviewVu)this.getVu()).setCurrentPosition(this.mCurPosition);
    }

    @Override
    public int getImageSize() {
        return this.mImageItemList.size();
    }

    @Override
    public ImageItem getImageItem(int position) {
        return this.mImageItemList.get(position);
    }

    @Override
    public void updateItem(int position, ImageItem imageItem) {
        this.mImageItemList.remove(position);
        this.mImageItemList.add(position, imageItem);
        this.mAdapter.notifyDataSetChanged();
    }

    @Override
    public void sendImages(List<ImageItem> dataList) {
        ((ImagePreviewVu)this.getVu()).setProgressBarVisible(true);
        this.bSendingImage = true;
        ((ImagePreviewVu)this.getVu()).setProgressBarVisible(true);
        Observable.from(dataList).subscribeOn(Schedulers.newThread()).flatMap((Func1)new Func1<ImageItem, Observable<ImageThumbBean>>(){

            public Observable<ImageThumbBean> call(ImageItem imageItem) {
                return DataTools.createThumbNails(imageItem);
            }
        }).toList().observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<List<ImageThumbBean>>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                LogUtil.e("Create thumbnail error, " + e.getMessage());
                ImagePreviewActivity.this.bSendingImage = false;
                ((ImagePreviewVu)ImagePreviewActivity.this.getVu()).setProgressBarVisible(false);
                CommonTool.showToast(R.string.im_uikit_send_image_failed);
            }

            public void onNext(List<ImageThumbBean> imageThumbBeen) {
                ImagePreviewActivity.this.setResult(imageThumbBeen);
            }
        });
    }

    private void setResult(List<ImageThumbBean> thumbBean) {
        Intent intent = new Intent();
        Bundle bundle = new Bundle();
        ArrayList<ImageThumbBean> bundleList = new ArrayList<ImageThumbBean>();
        bundleList.addAll(thumbBean);
        bundle.putParcelableArrayList("album_pic_select", bundleList);
        intent.putExtras(bundle);
        this.setResult(2, intent);
        this.finish();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        this.bSendingImage = false;
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (this.bSendingImage) {
            return true;
        }
        return super.dispatchTouchEvent(ev);
    }
}

